/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.network;

import java.util.function.Supplier;
import net.mcreator.missingandnewpotions.MissingAndNewPotionsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class MissingAndNewPotionsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"missing_and_new_potions");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MissingAndNewPotionsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        MissingAndNewPotionsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(MissingAndNewPotionsModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(MissingAndNewPotionsModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.oxygenAmount = original.oxygenAmount;
        clone.oxygenTankTime = original.oxygenTankTime;
        clone.loseOxygen = original.loseOxygen;
        clone.usedOxygen = original.usedOxygen;
        clone.masMetMoonRabbit = original.masMetMoonRabbit;
        clone.hasRiceCakeRecipeLearned = original.hasRiceCakeRecipeLearned;
        clone.riceCakeTime = original.riceCakeTime;
        clone.crash0 = original.crash0;
        clone.crash1 = original.crash1;
        clone.fallSpeed = original.fallSpeed;
        clone.fallAmount = original.fallAmount;
        clone.up = original.up;
        clone.gm = original.gm;
        clone.blackholeDestroyTime = original.blackholeDestroyTime;
        clone.blackholeDestroyIt = original.blackholeDestroyIt;
        clone.blood_type = original.blood_type;
        clone.blackholeLife = original.blackholeLife;
        clone.amplfier = original.amplfier;
        if (!event.isWasDeath()) {
            clone.fishByPotion = original.fishByPotion;
            clone.gravity = original.gravity;
            clone.justInfection = original.justInfection;
            clone.u = original.u;
            clone.d = original.d;
            clone.gravityOn = original.gravityOn;
            clone.earthquake = original.earthquake;
            clone.earthquakeTime = original.earthquakeTime;
            clone.earthquakeTimeTrigger = original.earthquakeTimeTrigger;
            clone.earthquakeTrigger = original.earthquakeTrigger;
            clone.tiemSet = original.tiemSet;
            clone.nie = original.nie;
            clone.nieSet = original.nieSet;
            clone.tiem = original.tiem;
            clone.x = original.x;
            clone.z = original.z;
            clone.y = original.y;
            clone.jump = original.jump;
            clone.jumpAmount = original.jumpAmount;
            clone.imposter = original.imposter;
            clone.blackholeSingularityTake = original.blackholeSingularityTake;
            clone.gma = original.gma;
            clone.fire = original.fire;
            clone.x_loc = original.x_loc;
            clone.y_loc = original.y_loc;
            clone.z_loc = original.z_loc;
            clone.hasSleep = original.hasSleep;
            clone.gamemode = original.gamemode;
            clone.duration = original.duration;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"missing_and_new_potions", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            SavedData patt0$temp = message.data;
            if (patt0$temp instanceof MapVariables) {
                MapVariables mapVariables = (MapVariables)patt0$temp;
                buffer.writeNbt((Tag)mapVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            } else {
                SavedData patt1$temp = message.data;
                if (patt1$temp instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)patt1$temp;
                    buffer.writeNbt((Tag)worldVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(((MapVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(((WorldVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"missing_and_new_potions", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public double oxygenAmount = 0.0;
        public double oxygenTankTime = 1.0;
        public double loseOxygen = 1.0;
        public boolean usedOxygen = false;
        public boolean masMetMoonRabbit = false;
        public boolean hasRiceCakeRecipeLearned = false;
        public double riceCakeTime = 0.0;
        public boolean crash0 = false;
        public boolean crash1 = false;
        public double fishByPotion = 0.0;
        public double fallSpeed = 1.0;
        public double fallAmount = 0.0;
        public String gravity = "\"\"";
        public boolean up = false;
        public boolean justInfection = false;
        public boolean u = false;
        public boolean d = false;
        public boolean gravityOn = true;
        public boolean earthquake = false;
        public double earthquakeTime = 0.0;
        public boolean earthquakeTimeTrigger = false;
        public boolean earthquakeTrigger = false;
        public boolean tiemSet = false;
        public double nie = 0.0;
        public boolean nieSet = false;
        public double tiem = 0.0;
        public double x = 0.0;
        public double z = 0.0;
        public double y = 0.0;
        public boolean jump = false;
        public double jumpAmount = 0.0;
        public String gm = "";
        public boolean imposter = false;
        public double blackholeDestroyTime = 0.0;
        public double blackholeDestroyIt = 1.0;
        public double blackholeSingularityTake = 0.0;
        public double gma = 0.0;
        public boolean fire = false;
        public String blood_type = "\"null\"";
        public double x_loc = 0.0;
        public double y_loc = 0.0;
        public double z_loc = 0.0;
        public boolean hasSleep = false;
        public String gamemode = "\"\"";
        public double blackholeLife = 0.0;
        public double amplfier = 0.0;
        public double duration = 0.0;

        public void serialize(ValueOutput output) {
            output.putDouble("oxygenAmount", this.oxygenAmount);
            output.putDouble("oxygenTankTime", this.oxygenTankTime);
            output.putDouble("loseOxygen", this.loseOxygen);
            output.putBoolean("usedOxygen", this.usedOxygen);
            output.putBoolean("masMetMoonRabbit", this.masMetMoonRabbit);
            output.putBoolean("hasRiceCakeRecipeLearned", this.hasRiceCakeRecipeLearned);
            output.putDouble("riceCakeTime", this.riceCakeTime);
            output.putBoolean("crash0", this.crash0);
            output.putBoolean("crash1", this.crash1);
            output.putDouble("fishByPotion", this.fishByPotion);
            output.putDouble("fallSpeed", this.fallSpeed);
            output.putDouble("fallAmount", this.fallAmount);
            output.putString("gravity", this.gravity);
            output.putBoolean("up", this.up);
            output.putBoolean("justInfection", this.justInfection);
            output.putBoolean("u", this.u);
            output.putBoolean("d", this.d);
            output.putBoolean("gravityOn", this.gravityOn);
            output.putBoolean("earthquake", this.earthquake);
            output.putDouble("earthquakeTime", this.earthquakeTime);
            output.putBoolean("earthquakeTimeTrigger", this.earthquakeTimeTrigger);
            output.putBoolean("earthquakeTrigger", this.earthquakeTrigger);
            output.putBoolean("tiemSet", this.tiemSet);
            output.putDouble("nie", this.nie);
            output.putBoolean("nieSet", this.nieSet);
            output.putDouble("tiem", this.tiem);
            output.putDouble("x", this.x);
            output.putDouble("z", this.z);
            output.putDouble("y", this.y);
            output.putBoolean("jump", this.jump);
            output.putDouble("jumpAmount", this.jumpAmount);
            output.putString("gm", this.gm);
            output.putBoolean("imposter", this.imposter);
            output.putDouble("blackholeDestroyTime", this.blackholeDestroyTime);
            output.putDouble("blackholeDestroyIt", this.blackholeDestroyIt);
            output.putDouble("blackholeSingularityTake", this.blackholeSingularityTake);
            output.putDouble("gma", this.gma);
            output.putBoolean("fire", this.fire);
            output.putString("blood_type", this.blood_type);
            output.putDouble("x_loc", this.x_loc);
            output.putDouble("y_loc", this.y_loc);
            output.putDouble("z_loc", this.z_loc);
            output.putBoolean("hasSleep", this.hasSleep);
            output.putString("gamemode", this.gamemode);
            output.putDouble("blackholeLife", this.blackholeLife);
            output.putDouble("amplfier", this.amplfier);
            output.putDouble("duration", this.duration);
        }

        public void deserialize(ValueInput input) {
            this.oxygenAmount = input.getDoubleOr("oxygenAmount", 0.0);
            this.oxygenTankTime = input.getDoubleOr("oxygenTankTime", 0.0);
            this.loseOxygen = input.getDoubleOr("loseOxygen", 0.0);
            this.usedOxygen = input.getBooleanOr("usedOxygen", false);
            this.masMetMoonRabbit = input.getBooleanOr("masMetMoonRabbit", false);
            this.hasRiceCakeRecipeLearned = input.getBooleanOr("hasRiceCakeRecipeLearned", false);
            this.riceCakeTime = input.getDoubleOr("riceCakeTime", 0.0);
            this.crash0 = input.getBooleanOr("crash0", false);
            this.crash1 = input.getBooleanOr("crash1", false);
            this.fishByPotion = input.getDoubleOr("fishByPotion", 0.0);
            this.fallSpeed = input.getDoubleOr("fallSpeed", 0.0);
            this.fallAmount = input.getDoubleOr("fallAmount", 0.0);
            this.gravity = input.getStringOr("gravity", "");
            this.up = input.getBooleanOr("up", false);
            this.justInfection = input.getBooleanOr("justInfection", false);
            this.u = input.getBooleanOr("u", false);
            this.d = input.getBooleanOr("d", false);
            this.gravityOn = input.getBooleanOr("gravityOn", false);
            this.earthquake = input.getBooleanOr("earthquake", false);
            this.earthquakeTime = input.getDoubleOr("earthquakeTime", 0.0);
            this.earthquakeTimeTrigger = input.getBooleanOr("earthquakeTimeTrigger", false);
            this.earthquakeTrigger = input.getBooleanOr("earthquakeTrigger", false);
            this.tiemSet = input.getBooleanOr("tiemSet", false);
            this.nie = input.getDoubleOr("nie", 0.0);
            this.nieSet = input.getBooleanOr("nieSet", false);
            this.tiem = input.getDoubleOr("tiem", 0.0);
            this.x = input.getDoubleOr("x", 0.0);
            this.z = input.getDoubleOr("z", 0.0);
            this.y = input.getDoubleOr("y", 0.0);
            this.jump = input.getBooleanOr("jump", false);
            this.jumpAmount = input.getDoubleOr("jumpAmount", 0.0);
            this.gm = input.getStringOr("gm", "");
            this.imposter = input.getBooleanOr("imposter", false);
            this.blackholeDestroyTime = input.getDoubleOr("blackholeDestroyTime", 0.0);
            this.blackholeDestroyIt = input.getDoubleOr("blackholeDestroyIt", 0.0);
            this.blackholeSingularityTake = input.getDoubleOr("blackholeSingularityTake", 0.0);
            this.gma = input.getDoubleOr("gma", 0.0);
            this.fire = input.getBooleanOr("fire", false);
            this.blood_type = input.getStringOr("blood_type", "");
            this.x_loc = input.getDoubleOr("x_loc", 0.0);
            this.y_loc = input.getDoubleOr("y_loc", 0.0);
            this.z_loc = input.getDoubleOr("z_loc", 0.0);
            this.hasSleep = input.getBooleanOr("hasSleep", false);
            this.gamemode = input.getStringOr("gamemode", "");
            this.blackholeLife = input.getDoubleOr("blackholeLife", 0.0);
            this.amplfier = input.getDoubleOr("amplfier", 0.0);
            this.duration = input.getDoubleOr("duration", 0.0);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("missing_and_new_potions_mapvars", ctx -> new MapVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            MapVariables instance = new MapVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double deathTime = 0.0;
        static MapVariables clientSide = new MapVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.deathTime = nbt.getDoubleOr("deathTime", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("deathTime", this.deathTime);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAccessor.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("missing_and_new_potions_worldvars", ctx -> new WorldVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            WorldVariables instance = new WorldVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double blackHoleX = 0.0;
        public double blackHoleY = 0.0;
        public double blackHoleZ = 0.0;
        public double m = 0.9;
        static WorldVariables clientSide = new WorldVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.blackHoleX = nbt.getDoubleOr("blackHoleX", 0.0);
            this.blackHoleY = nbt.getDoubleOr("blackHoleY", 0.0);
            this.blackHoleZ = nbt.getDoubleOr("blackHoleZ", 0.0);
            this.m = nbt.getDoubleOr("m", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("blackHoleX", this.blackHoleX);
            nbt.putDouble("blackHoleY", this.blackHoleY);
            nbt.putDouble("blackHoleZ", this.blackHoleZ);
            nbt.putDouble("m", this.m);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }
}

