/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missingandnewpotions.network;

import net.mcreator.missingandnewpotions.MissingAndNewPotionsMod;
import net.mcreator.missingandnewpotions.procedures.OpenSpaceSuitOxygenGUIOnKeyPressedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record OpenSpaceSuitOxygenGUIMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenSpaceSuitOxygenGUIMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"missing_and_new_potions", (String)"key_open_space_suit_oxygen_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenSpaceSuitOxygenGUIMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new OpenSpaceSuitOxygenGUIMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<OpenSpaceSuitOxygenGUIMessage> type() {
        return TYPE;
    }

    public static void handleData(OpenSpaceSuitOxygenGUIMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> OpenSpaceSuitOxygenGUIMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            OpenSpaceSuitOxygenGUIOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MissingAndNewPotionsMod.addNetworkMessage(TYPE, STREAM_CODEC, OpenSpaceSuitOxygenGUIMessage::handleData);
    }
}

