/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.rubixdev.inventorio.config.SettingsEntry;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0012R6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lde/rubixdev/inventorio/config/AbstractSettings;", "", "<init>", "()V", "Lcom/google/gson/JsonObject;", "jsonObject", "", "anyChanges", "(Lcom/google/gson/JsonObject;)Z", "asJson", "()Lcom/google/gson/JsonObject;", "fromJson", "Ljava/io/File;", "configFile", "", "load", "(Ljava/io/File;)V", "save", "Ljava/io/File;", "", "Lde/rubixdev/inventorio/config/SettingsEntry;", "<set-?>", "entries", "Ljava/util/List;", "getEntries", "()Ljava/util/List;", "setEntries", "(Ljava/util/List;)V", "inventorio-mc1.20.2-fabric"})
@SourceDebugExtension(value={"SMAP\nAbstractSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSettings.kt\nde/rubixdev/inventorio/config/AbstractSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1855#2,2:54\n1747#2,3:56\n1747#2,3:59\n1#3:62\n*S KotlinDebug\n*F\n+ 1 AbstractSettings.kt\nde/rubixdev/inventorio/config/AbstractSettings\n*L\n16#1:54,2\n25#1:56,3\n32#1:59,3\n*E\n"})
public abstract class AbstractSettings {
    private File configFile;
    @NotNull
    private List<? extends SettingsEntry> entries = CollectionsKt.emptyList();

    @NotNull
    public final List<SettingsEntry> getEntries() {
        return this.entries;
    }

    protected final void setEntries(@NotNull List<? extends SettingsEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entries = list;
    }

    @NotNull
    public final JsonObject asJson() {
        JsonObject configRoot = new JsonObject();
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsEntry it = (SettingsEntry)element$iv;
            boolean bl = false;
            configRoot.add(it.configKey, (JsonElement)it.valueAsElement.invoke(it.getValue()));
        }
        return configRoot;
    }

    public final boolean fromJson(@NotNull JsonObject jsonObject) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            Iterable $this$any$iv = this.entries;
            boolean bl2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SettingsEntry it = (SettingsEntry)element$iv;
                    boolean bl22 = false;
                    if (!(!jsonObject.has(it.configKey))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean missingEntries = bl;
        for (SettingsEntry settingsEntry : this.entries) {
            settingsEntry.setValue(settingsEntry.tryElementAsValue(jsonObject.get(settingsEntry.configKey)));
        }
        return missingEntries;
    }

    public final boolean anyChanges(@NotNull JsonObject jsonObject) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SettingsEntry option = (SettingsEntry)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)option.getValue(), (Object)option.tryElementAsValue(jsonObject.get(option.configKey))))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            File file = this.configFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configFile");
                file = null;
            }
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                new Gson().toJson((JsonElement)this.asJson(), (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull File configFile) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            try {
                this.configFile = configFile;
                if (configFile.exists()) {
                    boolean bl;
                    Closeable closeable = new FileReader(configFile);
                    Throwable throwable = null;
                    try {
                        FileReader it = (FileReader)closeable;
                        boolean bl2 = false;
                        Object object = new Gson().fromJson((Reader)it, JsonObject.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(it, JsonObject::class.java)");
                        bl = this.fromJson((JsonObject)object);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (!bl) break block10;
                }
                this.save();
            }
            catch (Exception ignored) {
                this.save();
            }
        }
    }
}

