/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player.inventory;

import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.GeneralConstants;
import de.rubixdev.inventorio.util.RandomStuff;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\rJ\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryExtension;", "Lnet/minecraft/class_1657;", "player", "<init>", "(Lnet/minecraft/class_1657;)V", "Lnet/minecraft/class_1799;", "bowStack", "getActiveArrowType", "(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "sourceStack", "", "insertOnlySimilarStack", "(Lnet/minecraft/class_1799;)Z", "insertStackIntoEmptySlot", "", "xpAmount", "mendToolBeltItems", "(I)I", "removeOne", "targetStack", "", "transfer", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1799;)V", "inventorio-mc1.20.2-fabric"})
@SourceDebugExtension(value={"SMAP\nPlayerInventoryInjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryInjects.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n288#2,2:113\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryInjects.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryInjects\n*L\n34#1:113,2\n*E\n"})
public abstract class PlayerInventoryInjects
extends PlayerInventoryExtension {
    protected PlayerInventoryInjects(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
    }

    public final int mendToolBeltItems(int xpAmount) {
        int xpLeft = xpAmount;
        for (class_1799 itemStack : this.toolBelt) {
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"itemStack");
            if (!RandomStuff.isNotEmpty(itemStack) || !itemStack.method_7986()) continue;
            class_1887 class_18872 = class_1893.field_9101;
            Intrinsics.checkNotNullExpressionValue((Object)class_18872, (String)"MENDING");
            if (RandomStuff.getLevelOn(class_18872, itemStack) <= 0) continue;
            int damageRestored = Math.min(xpAmount * 2, itemStack.method_7919());
            itemStack.method_7974(itemStack.method_7919() - damageRestored);
            xpLeft = xpAmount - damageRestored / 2;
            return xpLeft > 0 ? this.mendToolBeltItems(xpLeft) : 0;
        }
        return xpLeft;
    }

    @Nullable
    public final class_1799 getActiveArrowType(@NotNull class_1799 bowStack) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)bowStack, (String)"bowStack");
            if (!(bowStack.method_7909() instanceof class_1811)) {
                return null;
            }
            class_1792 class_17922 = bowStack.method_7909();
            Intrinsics.checkNotNull((Object)class_17922, (String)"null cannot be cast to non-null type net.minecraft.item.RangedWeaponItem");
            Predicate predicate = ((class_1811)class_17922).method_20310();
            class_2371 class_23712 = this.stacks;
            Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"stacks");
            Iterable $this$firstOrNull$iv = (Iterable)class_23712;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                class_1799 it = (class_1799)element$iv;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    public final boolean insertOnlySimilarStack(@NotNull class_1799 sourceStack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        if (!sourceStack.method_7946()) {
            return false;
        }
        Object object = GeneralConstants.INVENTORY_HOTBAR_RANGE;
        int i = object.getFirst();
        if (i <= (n = object.getLast())) {
            while (true) {
                Object object2 = this.getPlayer().method_31548().field_7547.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"player.inventory.main[i]");
                class_1799 hotbarStack = (class_1799)object2;
                if (this.areItemsSimilar(sourceStack, hotbarStack) && hotbarStack.method_7947() < hotbarStack.method_7914()) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        for (class_1799 utilityStack : this.utilityBelt) {
            Intrinsics.checkNotNullExpressionValue((Object)utilityStack, (String)"utilityStack");
            if (!this.areItemsSimilar(sourceStack, utilityStack)) continue;
            this.transfer(sourceStack, utilityStack);
            if (!sourceStack.method_7960()) continue;
            return true;
        }
        object = this.getAvailableDeepPocketsRange();
        int index = object.getFirst();
        if (index <= (n = object.getLast())) {
            while (true) {
                class_1799 targetStack = (class_1799)this.deepPockets.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)targetStack, (String)"targetStack");
                if (this.areItemsSimilar(sourceStack, targetStack)) {
                    this.transfer(sourceStack, targetStack);
                    if (sourceStack.method_7960()) {
                        return true;
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
        return false;
    }

    public final boolean insertStackIntoEmptySlot(@NotNull class_1799 sourceStack) {
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        IntRange intRange = this.getAvailableDeepPocketsRange();
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                if (((class_1799)this.deepPockets.get(index)).method_7960()) {
                    this.deepPockets.set(index, sourceStack.method_7972());
                    sourceStack.method_7939(0);
                    this.method_5431();
                    return true;
                }
                if (index == n) break;
                ++index;
            }
        }
        return false;
    }

    private final void transfer(class_1799 sourceStack, class_1799 targetStack) {
        int j = Math.min(sourceStack.method_7947(), targetStack.method_7914() - targetStack.method_7947());
        if (j > 0) {
            targetStack.method_7933(j);
            sourceStack.method_7934(j);
            this.method_5431();
        }
    }

    public final boolean removeOne(@NotNull class_1799 sourceStack) {
        Intrinsics.checkNotNullParameter((Object)sourceStack, (String)"sourceStack");
        Iterator iterator = this.stacks.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            class_1799 stack = (class_1799)iterator.next();
            if (stack != sourceStack) continue;
            this.stacks.set(index, (Object)class_1799.field_8037);
            return true;
        }
        return false;
    }
}

