package de.rubixdev.inventorio.mixin;

import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1303.class)
public class ExperienceOrbEntityMixin {
    @Shadow
    private int amount;

    /**
     * This inject allows items in the ToolBelt to be Mended
     */
    @Inject(
        method = "onPlayerCollision",
        at = @At(value = "FIELD", target = "Lnet/minecraft/entity/ExperienceOrbEntity;amount:I"),
        require = 0
    )
    private void inventorioMendToolBeltItems(class_1657 player, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(player, addon -> this.amount = addon.mendToolBeltItems(this.amount));
    }
}
