package de.rubixdev.inventorio.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.player.PlayerAddonSerializer;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.MixinHelpers;
import de.rubixdev.inventorio.util.PlayerDuck;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements PlayerDuck {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract class_1661 getInventory();

    @Unique public PlayerInventoryAddon inventorioAddon;

    @Inject(method = "<init>", at = @At(value = "RETURN"))
    private void inventorioCreateAddon(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        class_1657 thisPlayer = (class_1657) (Object) this;
        inventorioAddon = new PlayerInventoryAddon(thisPlayer);
    }

    /**
     * This injection causes the selected UtilityBelt item to be displayed in
     * the offhand
     */
    @Inject(method = "getEquippedStack", at = @At(value = "HEAD"), cancellable = true)
    private void inventorioDisplayOffhand(class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot == class_1304.field_6171) cir.setReturnValue(inventorioAddon.getDisplayedOffHandStack());
    }

    /**
     * These 2 mixins govern the custom behavior of displaying items in both
     * hands. First, the offhand is attached to the utility belt, rather than a
     * vanilla slot. Second, a player can swap the main hand and the offhand.
     */
    @SuppressWarnings("unchecked")
    @WrapOperation(
        method = "equipStack",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/util/collection/DefaultedList;set(ILjava/lang/Object;)Ljava/lang/Object;",
            ordinal = 0
        )
    )
    private <E> E inventorioEquipMainHand(class_2371<E> instance, int index, E element, Operation<E> original) {
        if (inventorioAddon.getSwappedHands()) {
            inventorioAddon.setSelectedUtilityStack((class_1799) element);
            // TODO: should this return something else?
            return (E) class_1799.field_8037;
        }
        return original.call(instance, index, element);
    }

    @SuppressWarnings("unchecked")
    @Redirect(
        method = "equipStack",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/util/collection/DefaultedList;set(ILjava/lang/Object;)Ljava/lang/Object;",
            ordinal = 1
        )
    )
    private <E> E inventorioEquipOffhand(class_2371<E> defaultedList, int index, E stack) {
        class_1799 itemStack = (class_1799) stack;
        if (inventorioAddon.getSwappedHands()) inventorioAddon.setSelectedHotbarStack(itemStack);
        else inventorioAddon.setSelectedUtilityStack(itemStack);
        // TODO: should this return something else?
        return (E) class_1799.field_8037;
    }

    /**
     * This mixin refreshes the available slots when we equip armor through
     * right-clicking or a dispenser
     */
    @Inject(method = "equipStack", at = @At(value = "RETURN"))
    private void inventorioOnEquipArmor(class_1304 slot, class_1799 stack, CallbackInfo ci) {
        if (slot.method_5925() == class_1304.class_1305.field_6178) MixinHelpers
            .withScreenHandler((class_1657) (Object) this, InventorioScreenHandler::updateDeepPocketsCapacity);
    }

    /**
     * This mixin allows arrows stored in the addon slots to be used by a bow
     */
    @ModifyReturnValue(method = "getProjectileType", at = @At("RETURN"))
    private class_1799 inventorioGetArrowType(class_1799 original, class_1799 bowStack) {
        if (!original.method_7960()) return original;
        class_1799 arrowStack = inventorioAddon.getActiveArrowType(bowStack);
        return arrowStack != null ? arrowStack : original;
    }

    /**
     * These 2 injections cause a correct weapon to be automatically selected
     * and withdrawn upon attack
     */
    @Inject(method = "attack", at = @At(value = "HEAD"))
    private void inventorioPreAttack(class_1297 target, CallbackInfo ci) {
        if (target.method_5732()) inventorioAddon.prePlayerAttack();
    }

    @Inject(method = "attack", at = @At(value = "RETURN"))
    private void inventorioPostAttack(class_1297 target, CallbackInfo ci) {
        if (target.method_5732()) inventorioAddon.postPlayerAttack();
    }

    /**
     * These 2 injections read and write additional data into Player's NBT
     */
    @Inject(method = "readCustomDataFromNbt", at = @At(value = "RETURN"))
    private void inventorioDeserializePlayerAddon(class_2487 tag, CallbackInfo ci) {
        PlayerAddonSerializer.INSTANCE
            .deserialize(this.method_56673(), inventorioAddon, tag.method_10562("Inventorio"));
    }

    @Inject(method = "writeCustomDataToNbt", at = @At(value = "RETURN"))
    private void inventorioSerializePlayerAddon(class_2487 tag, CallbackInfo ci) {
        class_2487 inventorioTag = new class_2487();
        PlayerAddonSerializer.INSTANCE.serialize(this.method_56673(), inventorioAddon, inventorioTag);
        tag.method_10566("Inventorio", inventorioTag);
    }

    @Inject(method = "tickMovement", at = @At(value = "RETURN"))
    private void inventorioTick(CallbackInfo ci) {
        inventorioAddon.tick();
    }

    @Nullable @Override
    public PlayerInventoryAddon inventorio$getInventorioAddon() {
        return inventorioAddon;
    }
}
