package de.rubixdev.inventorio.mixin.client;

import de.rubixdev.inventorio.client.control.InventorioControls;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_636.class)
public class ClientPlayerInteractionManagerMixin {
    /**
     * The default implementation stops an item from being used if the vanilla
     * "use" key isn't pressed. This mod adds an optional secondary use key, and
     * this prevents the secondary item usage from being cancelled
     */
    @Inject(method = "stopUsingItem", at = @At(value = "HEAD"), cancellable = true)
    private void inventorioStopUsingItem(class_1657 player, CallbackInfo ci) {
        if (PlayerInventoryAddon.Client.isUsingUtility) {
            if (InventorioControls.keyUseUtility.isPressed()) ci.cancel();
            else PlayerInventoryAddon.Client.isUsingUtility = false;
        }
    }
}
