package de.rubixdev.inventorio.mixin.optional.bowfix;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import de.rubixdev.inventorio.util.BowTester;
import de.rubixdev.inventorio.util.RandomStuff;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Restriction(require = @Condition(type = Condition.Type.TESTER, tester = BowTester.class))
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    /**
     * This fixes a bug that an Infinity Bow requires an arrow to shoot.
     */
    @ModifyExpressionValue(
        method = "getProjectileType",
        at = @At(
            value = "FIELD",
            target = "Lnet/minecraft/entity/player/PlayerAbilities;creativeMode:Z",
            opcode = Opcodes.GETFIELD
        )
    )
    private boolean inventorioFixInfinityBow(boolean original, class_1799 bow) {
        //#if MC >= 12101
        var infinity = RandomStuff.getEnchantment(this, class_1893.field_9125);
        //#else
        //$$ var infinity = Enchantments.INFINITY;
        //#endif
        return original || RandomStuff.getLevelOn(infinity, bow) > 0;
    }
}
