package de.rubixdev.inventorio.mixin;

import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets = "net.minecraft.server.network.ServerPlayerEntity$1")
public class ServerPlayerEntity_ScreenHandlerSyncHandlerMixin {
    @Shadow
    @Final
    ServerPlayer field_29182;

    @Inject(method = "updateState", at = @At("HEAD"))
    private void updateAddonState(
        AbstractContainerMenu handler,
        NonNullList<ItemStack> stacks,
        ItemStack cursorStack,
        int[] properties,
        CallbackInfo ci
    ) {
        MixinHelpers.withInventoryAddon(this.field_29182, PlayerInventoryExtension::updateState);
    }
}
