package de.rubixdev.inventorio.mixin.accessor;

import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@SuppressWarnings("unused")
@Mixin(AbstractContainerMenu.class)
public interface ScreenHandlerAccessor {
    @Accessor
    NonNullList<ItemStack> getTrackedStacks();

    @Accessor
    NonNullList<ItemStack> getPreviousTrackedStacks();

    @Invoker
    Slot callAddSlot(Slot slot);

    @Invoker
    boolean callInsertItem(ItemStack stack, int firstIndex, int lastIndex, boolean fromLast);
}
