package de.rubixdev.inventorio.mixin.accessor;

import net.minecraft.core.NonNullList;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(SimpleContainer.class)
public interface SimpleInventoryAccessor {
    @Accessor("size")
    @Mutable
    void setSize(int size);

    @Accessor("heldStacks")
    @Mutable
    void setHeldStacks(NonNullList<ItemStack> stacks);

    @Accessor("heldStacks")
    NonNullList<ItemStack> getHeldStacks();
}
