package de.rubixdev.inventorio.mixin.client;

import de.rubixdev.inventorio.client.control.InventorioControls;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(Dist.CLIENT)
@Mixin(MultiPlayerGameMode.class)
public class ClientPlayerInteractionManagerMixin {
    /**
     * The default implementation stops an item from being used if the vanilla
     * "use" key isn't pressed. This mod adds an optional secondary use key, and
     * this prevents the secondary item usage from being cancelled
     */
    @Inject(method = "stopUsingItem", at = @At(value = "HEAD"), cancellable = true)
    private void inventorioStopUsingItem(Player player, CallbackInfo ci) {
        if (PlayerInventoryAddon.Client.isUsingUtility) {
            if (InventorioControls.keyUseUtility.isPressed()) ci.cancel();
            else PlayerInventoryAddon.Client.isUsingUtility = false;
        }
    }
}
