package de.rubixdev.inventorio.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value = AbstractContainerScreen.class)
@OnlyIn(Dist.CLIENT)
public class HandledScreenMixin {
    @Shadow
    @Nullable protected Slot focusedSlot;

    /**
     * This injection allows to use the vanilla Swap Offhand key (F by default)
     * to move items to the Utility Belt in the inventory (the injected method
     * is an edge-case handler when you have "swap offhand" on mouse buttons)
     */
    @WrapOperation(
        method = "onMouseClick(I)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V",
            ordinal = 0
        ),
        slice = @Slice(
            from = @At(
                value = "FIELD",
                target = "Lnet/minecraft/client/option/GameOptions;swapHandsKey:Lnet/minecraft/client/option/KeyBinding;"
            )
        )
    )
    private void inventorioOffhandSwapWithMouse(
        AbstractContainerScreen<?> instance,
        Slot slot,
        int slotId,
        int button,
        ClickType actionType,
        Operation<Void> original
    ) {
        MixinHelpers.withScreenHandler(
            Minecraft.getInstance().player,
            screenHandler -> screenHandler.tryTransferToUtilityBeltSlot(focusedSlot),
            player -> original.call(instance, slot, slotId, button, actionType, original)
        );
    }

    /**
     * This injection allows to use the vanilla Swap Offhand key (F by default)
     * to move items to the Utility Belt in the inventory
     */
    @WrapOperation(
        method = "handleHotbarKeyPressed",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V",
            ordinal = 0
        ),
        slice = @Slice(
            from = @At(
                value = "FIELD",
                target = "Lnet/minecraft/client/option/GameOptions;swapHandsKey:Lnet/minecraft/client/option/KeyBinding;"
            )
        )
    )
    private void inventorioOffhandSwapWithKeyboard(
        AbstractContainerScreen<?> instance,
        Slot slot,
        int slotId,
        int button,
        ClickType actionType,
        Operation<Void> original
    ) {
        MixinHelpers.withScreenHandler(
            Minecraft.getInstance().player,
            screenHandler -> screenHandler.tryTransferToUtilityBeltSlot(focusedSlot),
            player -> original.call(instance, slot, slotId, button, actionType)
        );
    }
}
