package de.rubixdev.inventorio.mixin.client;

import de.rubixdev.inventorio.client.ui.HotbarHUDRenderer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = Gui.class, priority = 1500)
@OnlyIn(Dist.CLIENT)
public class InGameHudMixinHP {
    /**
     * This mixin calls the renderer of hotbar addons. Note: this mixin doesn't
     * work in NeoForge and is substituted with a NeoForge event.
     */
    @Inject(method = "render", at = @At(value = "RETURN"))
    private void inventorioRenderHotbarAddons(/* #if <- hack around formatter */
        GuiGraphics context,
        //#if MC >= 12101
        DeltaTracker tickCounter,
        //#else
        //$$ float tickDelta,
        //#endif
        CallbackInfo ci
    ) {
        HotbarHUDRenderer.INSTANCE.renderHotbarAddons(context);
    }

    /**
     * This mixin removes the vanilla offhand display (both the item frame and
     * the item)
     */
    @Redirect(
        method = "renderHotbarVanilla",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/player/PlayerEntity;getOffHandStack()Lnet/minecraft/item/ItemStack;"
        )
    )
    private ItemStack inventorioRemoveOffhandDisplayFromHotbar(Player playerEntity) {
        return ItemStack.EMPTY;
    }
}
