package de.rubixdev.inventorio.mixin.client;

import de.rubixdev.inventorio.client.ui.InventorioScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = InventoryScreen.class)
@OnlyIn(Dist.CLIENT)
public class InventoryScreenMixin {
    @Inject(method = "init", at = @At(value = "RETURN"))
    private void inventorioAddToggle(CallbackInfo ci) {
        InventorioScreen.addToggleButton((InventoryScreen) (Object) this);
    }
}
