package de.rubixdev.inventorio.mixin.client.accessor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

import java.util.List;

@Mixin(Screen.class)
@OnlyIn(Dist.CLIENT)
public interface ScreenAccessor {
    @Accessor("children")
    List<GuiEventListener> getChildren();

    @Accessor("drawables")
    List<Renderable> getDrawables();

    @Accessor("selectables")
    List<NarratableEntry> getSelectables();

    @Accessor
    @Nullable Minecraft getClient();

    @Accessor
    Font getTextRenderer();

    @Invoker
    <T extends GuiEventListener & Renderable> T callAddDrawableChild(T drawableElement);
}
