package de.rubixdev.inventorio.mixin.neoforge.curios;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.rubixdev.inventorio.integration.curios.ICuriosScreen;
import de.rubixdev.inventorio.util.CuriosTester;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.common.inventory.CurioSlot;

//#if MC >= 12101
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
//#endif

@Restriction(require = { @Condition("curios"), @Condition(type = Condition.Type.TESTER, tester = CuriosTester.class) })
@Mixin(AbstractContainerScreen.class)
public abstract class HandledScreenMixin extends Screen {
    protected HandledScreenMixin(Component title) {
        super(title);
    }

    @ModifyReturnValue(method = "isPointOverSlot", at = @At("RETURN"))
    private boolean dontRenderCuriosWhenClosed(boolean original, Slot slot) {
        if (
            this instanceof ICuriosScreen curiosScreen
                && slot instanceof CurioSlot
                && !curiosScreen.getInventorio$isCuriosOpen()
        ) {
            return false;
        }
        return original;
    }

    @Inject(method = "drawSlot", at = @At("HEAD"), cancellable = true)
    private void dontRenderCuriosWhenClosed(GuiGraphics context, Slot slot, CallbackInfo ci) {
        if (
            this instanceof ICuriosScreen curiosScreen
                && slot instanceof CurioSlot
                && !curiosScreen.getInventorio$isCuriosOpen()
        ) {
            ci.cancel();
        }
    }

    //#if MC >= 12101
    @ModifyVariable(
        method = "drawSlot",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/screen/ScreenHandler;getCursorStack()Lnet/minecraft/item/ItemStack;",
            ordinal = 0
        )
    )
    protected ItemStack drawSlot(ItemStack itemstack, GuiGraphics drawContext, Slot slot) {
        // noinspection ConstantValue
        if ((Screen) this instanceof InventorioScreen && slot instanceof CurioSlot curioSlot) {
            return curioSlot.getSlotExtension().getDisplayStack(curioSlot.getSlotContext(), itemstack);
        }

        return itemstack;
    }
    //#endif
}
