package de.rubixdev.inventorio.mixin.neoforge.curios;

import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.integration.curios.ICuriosScreen;
import de.rubixdev.inventorio.integration.curios.InventorioScreenMixinHelper;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.util.CuriosTester;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("UnresolvedMixinReference") // the Minecraft Dev plugin
                                              // doesn't seem to like Kotlin
                                              // target classes
@Restriction(require = { @Condition("curios"), @Condition(type = Condition.Type.TESTER, tester = CuriosTester.class) })
@Mixin(InventorioScreen.class)
public abstract class InventorioScreenMixin extends EffectRenderingInventoryScreen<InventorioScreenHandler>
    implements ICuriosScreen {
    public InventorioScreenMixin(InventorioScreenHandler arg, Inventory arg2, Component arg3) {
        super(arg, arg2, arg3);
    }

    @Shadow
    private RecipeBookComponent recipeBook;

    @SuppressWarnings("DataFlowIssue")
    @Unique private final InventorioScreen thiz = (InventorioScreen) (EffectRenderingInventoryScreen<?>) this;

    @Unique private InventorioScreenMixinHelper helper;

    @Override
    public void inventorio$updateRenderButtons() {
        helper.curios$updateRenderButtons(thiz);
    }

    @Override
    public boolean getInventorio$isCuriosOpen() { return helper.isCuriosOpen(); }

    @Inject(method = "init", at = @At("RETURN"))
    private void curios$init(CallbackInfo ci) {
        helper = new InventorioScreenMixinHelper(thiz, recipeBook);
        helper.curios$init(thiz);
    }

    @Inject(method = "render", at = @At("RETURN"))
    private void curios$render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        helper.curios$render(thiz, context, mouseX, mouseY, delta);
    }

    @Inject(method = "drawMouseoverTooltip", at = @At("RETURN"))
    private void curios$drawMouseoverTooltip(GuiGraphics context, int x, int y, CallbackInfo ci) {
        helper.curios$drawMouseoverTooltip(thiz, context, x, y);
    }

    @Inject(method = "drawBackground", at = @At("RETURN"))
    private void curios$drawBackground(GuiGraphics drawContext, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        helper.curios$drawBackground(thiz, drawContext);
    }

    @Inject(method = "isPointWithinBounds", at = @At("HEAD"), cancellable = true)
    private void curios$isPointWithinBounds(
        int xPosition,
        int yPosition,
        int width,
        int height,
        double pointX,
        double pointY,
        CallbackInfoReturnable<Boolean> cir
    ) {
        helper.isPointWithinBounds(cir);
    }

    @Inject(method = "mouseReleased", at = @At("HEAD"), cancellable = true)
    private void curios$mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        helper.mouseReleased(cir);
    }

    @Inject(method = "mouseScrolled", at = @At("HEAD"))
    private void curios$mouseScrolled(
        double mouseX,
        double mouseY,
        double horizontalAmount,
        double verticalAmount,
        CallbackInfoReturnable<Boolean> cir
    ) {
        helper.curios$mouseScrolled(thiz, mouseX, mouseY, verticalAmount);
    }

    @Inject(
        method = "init$lambda$0",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/recipebook/RecipeBookWidget;toggleOpen()V",
            shift = At.Shift.AFTER
        )
    )
    private static void curios$hideCuriosWhenOpeningRecipeBook(
        InventorioScreen instance,
        Button it,
        CallbackInfo ci
    ) {
        // noinspection DataFlowIssue
        ((InventorioScreenMixin) (AbstractContainerScreen<?>) instance).helper.curios$hideCuriosWhenOpeningRecipeBook(instance);
    }

    @Inject(method = "updateScreenPosition", at = @At("TAIL"), remap = false)
    private void curios$updateScreenPosition(CallbackInfo ci) {
        if (helper != null) {
            helper.curios$updateRenderButtons(thiz);
        }
    }
}
