package de.rubixdev.inventorio.mixin.neoforge.curios;

import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.integration.curios.CustomCuriosButton;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.client.gui.CuriosButton;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

@SuppressWarnings("UnresolvedMixinReference") // the Minecraft Dev plugin
                                              // doesn't seem to like Kotlin
                                              // target classes
@Restriction(
    require = @Condition("curios"),
    conflict = @Condition(
        type = Condition.Type.MIXIN,
        value = "de.rubixdev.inventorio.mixin.neoforge.curios.InventorioScreenMixin"
    )
)
@Mixin(InventorioScreen.class)
public abstract class InventorioScreenMixin_alternative extends EffectRenderingInventoryScreen<InventorioScreenHandler> {
    public InventorioScreenMixin_alternative(InventorioScreenHandler arg, Inventory arg2, Component arg3) {
        super(arg, arg2, arg3);
    }

    @Shadow
    private RecipeBookComponent recipeBook;

    @Inject(method = "init", at = @At("RETURN"))
    private void curios$init(CallbackInfo ci) {
        Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
        addRenderableWidget(
            new CustomCuriosButton(
                this,
                leftPos + offsets.getA() + 2,
                height / 2 + offsets.getB() + 2,
                10,
                10,
                CuriosButton.BIG,
                button -> {
                    MinecraftClient client = MinecraftClient.getInstance();
                    if (client.player != null) {
                        ItemStack stack = client.player.currentScreenHandler.getCursorStack();
                        client.player.currentScreenHandler.setCursorStack(ItemStack.EMPTY);

                        if (recipeBook.isOpen()) recipeBook.toggleOpen();
                        InventorioNetworking.getInstance().sendToServer(new CPacketOpenCurios(stack));
                    }
                }
            )
        );
    }
}
