package de.rubixdev.inventorio.mixin.optional.enderchest;

import com.mojang.authlib.GameProfile;
import de.rubixdev.inventorio.mixin.accessor.SimpleInventoryAccessor;
import de.rubixdev.inventorio.util.EnderChestTester;
import de.rubixdev.inventorio.util.GeneralConstants;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require = @Condition(type = Condition.Type.TESTER, tester = EnderChestTester.class))
@Mixin(Player.class)
public abstract class PlayerEntityMixin {
    @Shadow
    public abstract PlayerEnderChestContainer getEnderChestInventory();

    /**
     * This inject enlarges the Ender Chest's capacity to 6 rows.
     */
    @Inject(method = "<init>", at = @At(value = "RETURN"))
    private void inventorioResizeEnderChest(
        Level world,
        BlockPos pos,
        float yaw,
        GameProfile gameProfile,
        CallbackInfo ci
    ) {
        SimpleInventoryAccessor accessor = ((SimpleInventoryAccessor) getEnderChestInventory());
        accessor.setSize(GeneralConstants.VANILLA_ROW_LENGTH * 6);
        accessor.setHeldStacks(NonNullList.withSize(GeneralConstants.VANILLA_ROW_LENGTH * 6, ItemStack.EMPTY));
    }
}
