/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.api;

import com.google.common.collect.ImmutableList;
import de.rubixdev.inventorio.api.InventorioTickHandler;
import de.rubixdev.inventorio.api.OnInitKt;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventorioAPI {
    public static final String SLOT_PICKAXE = "pickaxe";
    public static final String SLOT_SWORD = "sword";
    public static final String SLOT_AXE = "axe";
    public static final String SLOT_SHOVEL = "shovel";
    public static final String SLOT_HOE = "hoe";

    private InventorioAPI() {
    }

    public static void registerInventoryTickHandler(@NotNull ResourceLocation customIdentifier, @NotNull InventorioTickHandler tickHandler) {
        PlayerInventoryAddon.registerTickHandler(customIdentifier, tickHandler);
    }

    public static void registerScreenHandlerOpenConsumer(@NotNull ResourceLocation customIdentifier, Consumer<InventorioScreenHandler> screenHandlerConsumer) {
        InventorioScreenHandler.registerOpenConsumer(customIdentifier, screenHandlerConsumer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerInventoryUIInitConsumer(@NotNull ResourceLocation customIdentifier, Consumer<InventorioScreen> uiConsumer) {
        InventorioScreen.registerInitConsumer(customIdentifier, uiConsumer);
    }

    @Nullable
    public static ToolBeltSlotTemplate registerToolBeltSlotIfNotExists(@NotNull String slotName, @NotNull ResourceLocation emptyIcon) {
        return PlayerInventoryAddon.registerToolBeltTemplateIfNotExists(slotName, new ToolBeltSlotTemplate(slotName, emptyIcon));
    }

    @Nullable
    public static ToolBeltSlotTemplate getToolBeltSlotTemplate(@NotNull String slotName) {
        return PlayerInventoryAddon.getToolBeltTemplate(slotName);
    }

    @NotNull
    public static ItemStack findFittingToolBeltStack(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull ItemStack sampleStack) {
        return playerInventoryAddon.findFittingToolBeltStack(sampleStack);
    }

    public static int findFittingToolBeltIndex(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull ItemStack sampleStack) {
        return playerInventoryAddon.findFittingToolBeltIndex(sampleStack);
    }

    @NotNull
    public static ImmutableList<ToolBeltSlotTemplate> getToolBeltTemplates() {
        return PlayerInventoryAddon.getToolBeltTemplates();
    }

    @Nullable
    public static PlayerInventoryAddon getInventoryAddon(@NotNull Player playerEntity) {
        return PlayerInventoryAddon.getInventoryAddon(playerEntity);
    }

    static {
        OnInitKt.onApiInit();
    }
}

