/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.client.control;

import com.mojang.blaze3d.platform.InputConstants;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lde/rubixdev/inventorio/client/control/KeyCoBinding;", "Lnet/minecraft/client/KeyMapping;", "", "coBindTranslationKey", "Lkotlin/Function0;", "vanillaBinging", "translationKey", "Lcom/mojang/blaze3d/platform/InputConstants$Type;", "type", "", "code", "category", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Lcom/mojang/blaze3d/platform/InputConstants$Type;ILjava/lang/String;)V", "Lcom/mojang/blaze3d/platform/InputConstants$Key;", "boundKey", "", "setBoundKey", "(Lcom/mojang/blaze3d/platform/InputConstants$Key;)V", "Lnet/minecraft/network/chat/Component;", "getBoundKeyLocalizedText", "()Lnet/minecraft/network/chat/Component;", "Ljava/lang/String;", "getCoBindTranslationKey", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function0;", "getVanillaBinging", "()Lkotlin/jvm/functions/Function0;", "", "isThisOrVanillaPressed", "()Z", "inventorio-mc1.21.1-neoforge"})
public class KeyCoBinding
extends KeyMapping {
    @NotNull
    private final String coBindTranslationKey;
    @NotNull
    private final Function0<KeyMapping> vanillaBinging;

    public KeyCoBinding(@NotNull String coBindTranslationKey, @NotNull Function0<? extends KeyMapping> vanillaBinging, @NotNull String translationKey, @NotNull InputConstants.Type type, int code, @NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)coBindTranslationKey, (String)"coBindTranslationKey");
        Intrinsics.checkNotNullParameter(vanillaBinging, (String)"vanillaBinging");
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(translationKey, type, code, category);
        this.coBindTranslationKey = coBindTranslationKey;
        this.vanillaBinging = vanillaBinging;
    }

    @NotNull
    protected final String getCoBindTranslationKey() {
        return this.coBindTranslationKey;
    }

    @NotNull
    protected final Function0<KeyMapping> getVanillaBinging() {
        return this.vanillaBinging;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isThisOrVanillaPressed() {
        if (this.isUnbound()) {
            boolean bl;
            KeyMapping keyMapping = (KeyMapping)this.vanillaBinging.invoke();
            if (keyMapping != null) {
                if (keyMapping.isDown()) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (!super.isDown()) return false;
        return true;
    }

    public void setKey(@NotNull InputConstants.Key boundKey) {
        Intrinsics.checkNotNullParameter((Object)boundKey, (String)"boundKey");
        super.setKey(boundKey);
        if (!this.isUnbound() && this.vanillaBinging.invoke() != null && this.same((KeyMapping)this.vanillaBinging.invoke())) {
            super.setKey(InputConstants.UNKNOWN);
        }
    }

    @NotNull
    public Component getTranslatedKeyMessage() {
        Component component;
        if (this.isUnbound()) {
            MutableComponent mutableComponent = Component.translatable((String)this.coBindTranslationKey);
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        } else {
            Component component2 = super.getTranslatedKeyMessage();
            Intrinsics.checkNotNull((Object)component2);
            component = component2;
        }
        return component;
    }
}

