/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.client.ui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import de.rubixdev.inventorio.config.PlayerSettings;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.util.HUDConstants;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.SegmentedHotbar;
import de.rubixdev.inventorio.util.UIConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\rJ/\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lde/rubixdev/inventorio/client/ui/HotbarHUDRenderer;", "", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "renderSegmentedHotbar", "(Lnet/minecraft/client/gui/GuiGraphics;)Z", "isHidden", "()Z", "", "renderHotbarAddons", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "x", "y", "renderItem", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;II)V", "renderFunctionOnlySelector", "drawSmallItem", "Lnet/minecraft/resources/ResourceLocation;", "WIDGETS_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "WIDGETS_TEXTURE_DARK", "Lnet/minecraft/client/Minecraft;", "client", "Lnet/minecraft/client/Minecraft;", "inventorio-mc1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nHotbarHUDRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotbarHUDRenderer.kt\nde/rubixdev/inventorio/client/ui/HotbarHUDRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,295:1\n12574#2,2:296\n*S KotlinDebug\n*F\n+ 1 HotbarHUDRenderer.kt\nde/rubixdev/inventorio/client/ui/HotbarHUDRenderer\n*L\n162#1:296,2\n*E\n"})
public final class HotbarHUDRenderer {
    @NotNull
    public static final HotbarHUDRenderer INSTANCE = new HotbarHUDRenderer();
    @NotNull
    private static final ResourceLocation WIDGETS_TEXTURE = RandomStuff.getId("textures/gui/widgets.png");
    @NotNull
    private static final ResourceLocation WIDGETS_TEXTURE_DARK = RandomStuff.getId("textures/gui/widgets_dark.png");
    @NotNull
    private static final Minecraft client;

    private HotbarHUDRenderer() {
    }

    public final boolean renderSegmentedHotbar(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.OFF || PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_FUNCTION || this.isHidden()) {
            return false;
        }
        Entity entity = HotbarHUDRenderer.client.cameraEntity;
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return false;
        }
        Player playerEntity = player;
        Inventory inventory = playerEntity.getInventory();
        int scaledWidthHalved = client.getWindow().getGuiScaledWidth() / 2 - 30;
        int scaledHeight = client.getWindow().getGuiScaledHeight();
        int selectedSection = PlayerInventoryAddon.Client.selectedHotbarSection;
        ResourceLocation texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
        drawContext.blit(texture, scaledWidthHalved - HUDConstants.HUD_SEGMENTED_HOTBAR.x, scaledHeight - HUDConstants.HUD_SEGMENTED_HOTBAR.y, HUDConstants.CANVAS_SEGMENTED_HOTBAR.x, HUDConstants.CANVAS_SEGMENTED_HOTBAR.y, HUDConstants.HUD_SEGMENTED_HOTBAR.width, HUDConstants.HUD_SEGMENTED_HOTBAR.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        if (selectedSection == -1) {
            drawContext.blit(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x - 4 + inventory.selected * HUDConstants.SLOT_HOTBAR_SIZE.width + 4 * (inventory.selected / 3), scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_POS.x, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_POS.y, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_SIZE.width, HUDConstants.CANVAS_VANILLA_SELECTION_FRAME_SIZE.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        } else {
            drawContext.blit(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + HUDConstants.HUD_SECTION_SELECTION.width * selectedSection - 4, scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.x, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.y, HUDConstants.HUD_SECTION_SELECTION.width, HUDConstants.HUD_SECTION_SELECTION.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        }
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            int x = scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + slotNum * HUDConstants.SLOT_HOTBAR_SIZE.width + 4 * (slotNum / 3);
            int y = scaledHeight - HUDConstants.SLOT_HOTBAR_SIZE.height;
            ItemStack itemStack = inventory.getItem(slotNum);
            drawContext.renderItem(itemStack, x, y);
            drawContext.renderItemDecorations(HotbarHUDRenderer.client.font, itemStack, x, y);
        }
        return true;
    }

    private final boolean isHidden() {
        block3: {
            block2: {
                if (HotbarHUDRenderer.client.gameMode == null) break block2;
                MultiPlayerGameMode multiPlayerGameMode = HotbarHUDRenderer.client.gameMode;
                if ((multiPlayerGameMode != null ? multiPlayerGameMode.getPlayerMode() : null) != GameType.SPECTATOR && !HotbarHUDRenderer.client.options.hideGui) break block3;
            }
            return true;
        }
        Entity entity = HotbarHUDRenderer.client.cameraEntity;
        Player player = entity instanceof Player ? (Player)entity : null;
        return player == null || !player.isAlive() || player.inventoryMenu == null;
    }

    public final void renderHotbarAddons(@NotNull GuiGraphics drawContext) {
        int leftHandedDisplayToolOffset;
        int segmentedModeOffset;
        int scaledHeight;
        int scaledWidthHalved;
        ItemStack selectedHotbarItem;
        PlayerInventoryAddon inventoryAddon;
        block11: {
            ResourceLocation texture;
            int leftHandedUtilityBeltOffset;
            ItemStack[] utilBeltDisplay;
            block10: {
                boolean bl;
                block9: {
                    boolean rightHanded;
                    Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
                    if (this.isHidden()) {
                        return;
                    }
                    PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Client.INSTANCE.getLocal();
                    if (playerInventoryAddon == null) {
                        return;
                    }
                    inventoryAddon = playerInventoryAddon;
                    Player player = inventoryAddon.getPlayer();
                    utilBeltDisplay = inventoryAddon.getDisplayedUtilities();
                    selectedHotbarItem = inventoryAddon.getSelectedHotbarStack();
                    scaledWidthHalved = client.getWindow().getGuiScaledWidth() / 2 - 30;
                    scaledHeight = client.getWindow().getGuiScaledHeight();
                    boolean drawSegmentedHotbar = PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_VISUAL || PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ON;
                    segmentedModeOffset = drawSegmentedHotbar ? 4 : 0;
                    boolean bl2 = rightHanded = player.getMainArm() == HumanoidArm.RIGHT;
                    if (inventoryAddon.getSwappedHands()) {
                        rightHanded = !rightHanded;
                    }
                    leftHandedUtilityBeltOffset = rightHanded ? 0 : 254 + segmentedModeOffset * 2;
                    leftHandedDisplayToolOffset = rightHanded ? 0 : -228 - segmentedModeOffset * 2;
                    texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    if (RandomStuff.isNotEmpty(inventoryAddon.getDisplayTool()) && !Intrinsics.areEqual((Object)inventoryAddon.getDisplayTool(), (Object)selectedHotbarItem)) {
                        drawContext.blit(texture, scaledWidthHalved + leftHandedDisplayToolOffset + HUDConstants.HUD_ACTIVE_TOOL_FRAME.x + segmentedModeOffset, scaledHeight - HUDConstants.HUD_ACTIVE_TOOL_FRAME.y, HUDConstants.CANVAS_ACTIVE_TOOL_FRAME.x, HUDConstants.CANVAS_ACTIVE_TOOL_FRAME.y, HUDConstants.HUD_ACTIVE_TOOL_FRAME.width, HUDConstants.HUD_ACTIVE_TOOL_FRAME.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
                    }
                    if (!PlayerSettings.skipEmptyUtilitySlots.getBoolValue()) break block10;
                    ItemStack[] $this$any$iv = utilBeltDisplay;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ItemStack element$iv;
                        ItemStack it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!RandomStuff.isNotEmpty(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (!bl) break block11;
            }
            drawContext.blit(texture, scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.HUD_UTILITY_BELT.x - segmentedModeOffset, scaledHeight - HUDConstants.HUD_UTILITY_BELT.y, HUDConstants.CANVAS_UTILITY_BELT_BCG.x, HUDConstants.CANVAS_UTILITY_BELT_BCG.y, HUDConstants.HUD_UTILITY_BELT.width, HUDConstants.HUD_UTILITY_BELT.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
            this.drawSmallItem(drawContext, utilBeltDisplay[0], (scaledWidthHalved + leftHandedUtilityBeltOffset - segmentedModeOffset) * 10 / 8 - HUDConstants.SLOT_UTILITY_BELT_1.x, Mth.ceil((double)((double)(scaledHeight - HUDConstants.SLOT_UTILITY_BELT_1.y) / 0.8)));
            this.drawSmallItem(drawContext, utilBeltDisplay[2], (scaledWidthHalved + leftHandedUtilityBeltOffset - segmentedModeOffset) * 10 / 8 - HUDConstants.SLOT_UTILITY_BELT_2.x, Mth.ceil((double)((double)(scaledHeight - HUDConstants.SLOT_UTILITY_BELT_2.y) / 0.8)));
            RenderSystem.applyModelViewMatrix();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
            drawContext.blit(texture, scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.HUD_UTILITY_BELT.x - segmentedModeOffset, scaledHeight - HUDConstants.HUD_UTILITY_BELT.y, HUDConstants.CANVAS_UTILITY_BELT.x, HUDConstants.CANVAS_UTILITY_BELT.y, HUDConstants.HUD_UTILITY_BELT.width, HUDConstants.HUD_UTILITY_BELT.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
            this.renderItem(drawContext, utilBeltDisplay[1], scaledWidthHalved + leftHandedUtilityBeltOffset - HUDConstants.SLOT_UTILITY_BELT_3.x - segmentedModeOffset, scaledHeight - HUDConstants.SLOT_UTILITY_BELT_3.y);
        }
        if (RandomStuff.isNotEmpty(inventoryAddon.getDisplayTool()) && !Intrinsics.areEqual((Object)inventoryAddon.getDisplayTool(), (Object)selectedHotbarItem)) {
            this.renderItem(drawContext, inventoryAddon.getDisplayTool(), scaledWidthHalved + leftHandedDisplayToolOffset + HUDConstants.SLOT_ACTIVE_TOOL_FRAME.x + segmentedModeOffset, scaledHeight - HUDConstants.SLOT_ACTIVE_TOOL_FRAME.y);
        }
        RenderSystem.enableBlend();
    }

    private final void renderItem(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (RandomStuff.isNotEmpty(stack)) {
            drawContext.renderItem(stack, x, y);
            drawContext.renderItemDecorations(HotbarHUDRenderer.client.font, stack, x, y);
        }
    }

    public final void renderFunctionOnlySelector(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        int selectedSection = PlayerInventoryAddon.Client.selectedHotbarSection;
        if (selectedSection != -1 && PlayerSettings.segmentedHotbar.getValue() == SegmentedHotbar.ONLY_FUNCTION) {
            int scaledWidthHalved = client.getWindow().getGuiScaledWidth() / 2 - 30;
            int scaledHeight = client.getWindow().getGuiScaledHeight();
            ResourceLocation texture = PlayerSettings.darkTheme.getBoolValue() ? WIDGETS_TEXTURE_DARK : WIDGETS_TEXTURE;
            drawContext.blit(texture, scaledWidthHalved - HUDConstants.HUD_SECTION_SELECTION.x + (HUDConstants.HUD_SECTION_SELECTION.width - 4) * selectedSection, scaledHeight - HUDConstants.HUD_SECTION_SELECTION.y, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.x, HUDConstants.CANVAS_SECTION_SELECTION_FRAME.y, HUDConstants.HUD_SECTION_SELECTION.width, HUDConstants.HUD_SECTION_SELECTION.height, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.x, UIConstants.CANVAS_WIDGETS_TEXTURE_SIZE.y);
        }
    }

    private final void drawSmallItem(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (!stack.isEmpty()) {
            BakedModel bakedModel = client.getItemRenderer().getModel(stack, null, null, 0);
            drawContext.pose().pushPose();
            drawContext.pose().scale(0.8f, 0.8f, 0.8f);
            drawContext.pose().translate((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean bl;
                drawContext.pose().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                drawContext.pose().scale(16.0f, 16.0f, 16.0f);
                boolean bl2 = bl = !bakedModel.usesBlockLight();
                if (bl) {
                    Lighting.setupForFlatItems();
                }
                client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, drawContext.pose(), (MultiBufferSource)drawContext.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                drawContext.flush();
                if (bl) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable var12) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)var12, (String)"Rendering item");
                CrashReportCategory crashReportSection = crashReport.addCategory("Item being rendered");
                crashReportSection.setDetail("Item Type", () -> HotbarHUDRenderer.drawSmallItem$lambda$1(stack));
                crashReportSection.setDetail("Item Components", () -> HotbarHUDRenderer.drawSmallItem$lambda$2(stack));
                crashReportSection.setDetail("Item Foil", () -> HotbarHUDRenderer.drawSmallItem$lambda$3(stack));
                throw new ReportedException(crashReport);
            }
            drawContext.pose().popPose();
        }
    }

    private static final String drawSmallItem$lambda$1(ItemStack $stack) {
        return $stack.getItem().toString();
    }

    private static final String drawSmallItem$lambda$2(ItemStack $stack) {
        return $stack.getComponents().toString();
    }

    private static final String drawSmallItem$lambda$3(ItemStack $stack) {
        return String.valueOf($stack.hasFoil());
    }

    static {
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNull((Object)minecraft);
        client = minecraft;
    }
}

