/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.enchantment;

import de.rubixdev.inventorio.InventorioResources;
import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.util.RandomStuff;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lde/rubixdev/inventorio/enchantment/DeepPocketsBookRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "category", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "Lnet/minecraft/world/item/crafting/CraftingInput;", "input", "Lnet/minecraft/world/level/Level;", "world", "", "matches", "(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Z", "Lnet/minecraft/core/HolderLookup$Provider;", "lookup", "Lnet/minecraft/world/item/ItemStack;", "craft", "(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "", "width", "height", "fits", "(II)Z", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getSerializer", "()Lnet/minecraft/world/item/crafting/RecipeSerializer;", "isIgnoredInRecipeBook", "()Z", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/crafting/Ingredient;", "getIngredients", "()Lnet/minecraft/core/NonNullList;", "getResult", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "Companion", "inventorio-mc1.21.1-neoforge"})
public final class DeepPocketsBookRecipe
extends CustomRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Ingredient SHULKER_SHELL;
    private static final Ingredient BOOKS;
    public static SimpleCraftingRecipeSerializer<DeepPocketsBookRecipe> SERIALIZER;

    public DeepPocketsBookRecipe(@NotNull CraftingBookCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(category);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!GlobalSettings.deepPocketsBookCraft.getBoolValue()) {
            return false;
        }
        int shells = 0;
        int books = 0;
        int n = input.size();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = input.getItem(i);
            if (SHULKER_SHELL.test(itemStack)) {
                ++shells;
            }
            if (!BOOKS.test(itemStack)) continue;
            ++books;
        }
        return shells == 2 && books == 1;
    }

    @NotNull
    public ItemStack craft(@NotNull CraftingInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack itemStack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)RandomStuff.getEnchantment(lookup, InventorioResources.INSTANCE.getDEEP_POCKETS()), 1));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"forEnchantment(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Companion.getSERIALIZER();
    }

    public boolean isSpecial() {
        return !GlobalSettings.deepPocketsBookCraft.getBoolValue();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        Object[] objectArray = new Ingredient[]{SHULKER_SHELL, BOOKS, SHULKER_SHELL};
        NonNullList nonNullList = NonNullList.of((Object)SHULKER_SHELL, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"copyOf(...)");
        return nonNullList;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        boolean bl = GlobalSettings.deepPocketsBookCraft.getBoolValue();
        if (bl) {
            ItemStack itemStack2 = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)RandomStuff.getEnchantment(lookup, InventorioResources.INSTANCE.getDEEP_POCKETS()), 1));
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"forEnchantment(...)");
        } else if (!bl) {
            ItemStack itemStack3 = ItemStack.EMPTY;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return itemStack;
    }

    static {
        ItemLike[] itemLikeArray = new ItemLike[]{Items.SHULKER_SHELL};
        SHULKER_SHELL = Ingredient.of((ItemLike[])itemLikeArray);
        itemLikeArray = new ItemLike[]{Items.BOOK, Items.WRITABLE_BOOK};
        BOOKS = Ingredient.of((ItemLike[])itemLikeArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007R.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006@\u0006X\u0086.\u00a2\u0006\u0018\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lde/rubixdev/inventorio/enchantment/DeepPocketsBookRecipe$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/crafting/Ingredient;", "kotlin.jvm.PlatformType", "SHULKER_SHELL", "Lnet/minecraft/world/item/crafting/Ingredient;", "BOOKS", "Lnet/minecraft/world/item/crafting/SimpleCraftingRecipeSerializer;", "Lde/rubixdev/inventorio/enchantment/DeepPocketsBookRecipe;", "SERIALIZER", "Lnet/minecraft/world/item/crafting/SimpleCraftingRecipeSerializer;", "getSERIALIZER", "()Lnet/minecraft/world/item/crafting/SimpleCraftingRecipeSerializer;", "setSERIALIZER", "(Lnet/minecraft/world/item/crafting/SimpleCraftingRecipeSerializer;)V", "getSERIALIZER$annotations", "inventorio-mc1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleCraftingRecipeSerializer<DeepPocketsBookRecipe> getSERIALIZER() {
            SimpleCraftingRecipeSerializer<DeepPocketsBookRecipe> simpleCraftingRecipeSerializer = SERIALIZER;
            if (simpleCraftingRecipeSerializer != null) {
                return simpleCraftingRecipeSerializer;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"SERIALIZER");
            return null;
        }

        public final void setSERIALIZER(@NotNull SimpleCraftingRecipeSerializer<DeepPocketsBookRecipe> simpleCraftingRecipeSerializer) {
            Intrinsics.checkNotNullParameter(simpleCraftingRecipeSerializer, (String)"<set-?>");
            SERIALIZER = simpleCraftingRecipeSerializer;
        }

        public static /* synthetic */ void getSERIALIZER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

