/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.integration.curios;

import de.rubixdev.inventorio.mixin.accessor.ScreenHandlerAccessor;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.util.RandomStuff;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.server.SPacketPage;
import top.theillusivec4.curios.common.network.server.SPacketQuickMove;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001OB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0005J\u0011\u0010\b\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0005J\u0019\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u0005J!\u0010\u0011\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0019\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0005J\u0011\u0010\u001f\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0005J\u0011\u0010 \u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0004\b \u0010\u0005J1\u0010$\u001a\u00020\u0006*\u00020\u00022\u0006\u0010!\u001a\u00020\t2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010*\u001a\u0004\u0018\u00010)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R$\u00103\u001a\u00020\t2\u0006\u00102\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R$\u00107\u001a\u00020\t2\u0006\u00102\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b7\u00104\u001a\u0004\b8\u00106R\u001d\u0010:\u001a\b\u0012\u0004\u0012\u00020\t098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020>098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010;R\u0016\u0010@\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u00104R\u0016\u0010A\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u00104R$\u0010B\u001a\u00020,2\u0006\u00102\u001a\u00020,8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bB\u0010.\u001a\u0004\bC\u0010DR$\u0010E\u001a\u00020,2\u0006\u00102\u001a\u00020,8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bE\u0010.\u001a\u0004\bE\u0010DR\"\u0010F\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u00104\u001a\u0004\bG\u00106\"\u0004\bH\u0010IR\u001a\u0010K\u001a\u00020J8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\bK\u0010L\u0012\u0004\bM\u0010N\u00a8\u0006P"}, d2={"Lde/rubixdev/inventorio/integration/curios/InventorioScreenHandlerMixinHelper;", "", "Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "thiz", "<init>", "(Lde/rubixdev/inventorio/player/InventorioScreenHandler;)V", "", "curios$init", "curios$resetSlots", "", "page", "curios$setPage", "(Lde/rubixdev/inventorio/player/InventorioScreenHandler;I)V", "curios$toggleCosmetics", "slot", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;", "ci", "curios$setStackInSlot", "(Lde/rubixdev/inventorio/player/InventorioScreenHandler;ILorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "sourceIndex", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "Lnet/minecraft/world/item/ItemStack;", "cir", "curios$quickMove", "(Lde/rubixdev/inventorio/player/InventorioScreenHandler;Lnet/minecraft/world/entity/player/Player;ILorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "stack", "findAvailableSlot", "(Lnet/minecraft/world/item/ItemStack;)I", "curios$nextPage", "curios$prevPage", "curios$checkQuickMove", "slotId", "Lnet/minecraft/world/inventory/ClickType;", "clickType", "curios$onSlotClick", "(Lde/rubixdev/inventorio/player/InventorioScreenHandler;ILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;)V", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "Ltop/theillusivec4/curios/api/type/capability/ICuriosItemHandler;", "curiosHandler", "Ltop/theillusivec4/curios/api/type/capability/ICuriosItemHandler;", "", "isLocalWorld", "Z", "Lkotlin/ranges/IntRange;", "curiosSlotRange", "Lkotlin/ranges/IntRange;", "value", "currentPage", "I", "getCurrentPage", "()I", "totalPages", "getTotalPages", "", "grid", "Ljava/util/List;", "getGrid", "()Ljava/util/List;", "Lde/rubixdev/inventorio/integration/curios/InventorioScreenHandlerMixinHelper$ProxySlot;", "proxySlots", "moveToPage", "moveFromIndex", "hasCosmetics", "getHasCosmetics", "()Z", "isViewingCosmetics", "panelWidth", "getPanelWidth", "setPanelWidth", "(I)V", "Lde/rubixdev/inventorio/mixin/accessor/ScreenHandlerAccessor;", "thiss", "Lde/rubixdev/inventorio/mixin/accessor/ScreenHandlerAccessor;", "getThiss$annotations", "()V", "ProxySlot", "inventorio-mc1.21.1-neoforge"})
public final class InventorioScreenHandlerMixinHelper {
    @NotNull
    private final Player player;
    @Nullable
    private final ICuriosItemHandler curiosHandler;
    private final boolean isLocalWorld;
    @NotNull
    private IntRange curiosSlotRange;
    private int currentPage;
    private int totalPages;
    @NotNull
    private final List<Integer> grid;
    @NotNull
    private final List<ProxySlot> proxySlots;
    private int moveToPage;
    private int moveFromIndex;
    private boolean hasCosmetics;
    private boolean isViewingCosmetics;
    private int panelWidth;
    @NotNull
    private final ScreenHandlerAccessor thiss;

    public InventorioScreenHandlerMixinHelper(@NotNull InventorioScreenHandler thiz) {
        Intrinsics.checkNotNullParameter((Object)((Object)thiz), (String)"thiz");
        Player player = thiz.getInventory().player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        this.player = player;
        this.curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)((LivingEntity)this.player)).orElse(null);
        this.isLocalWorld = this.player.level().isClientSide;
        this.curiosSlotRange = RangesKt.until((int)(InventorioScreenHandler.toolBeltRange.getLast() + 1), (int)thiz.slots.size());
        this.grid = new ArrayList();
        this.proxySlots = new ArrayList();
        this.moveToPage = -1;
        this.moveFromIndex = -1;
        this.thiss = (ScreenHandlerAccessor)((Object)thiz);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final int getCurrentPage() {
        return this.currentPage;
    }

    public final int getTotalPages() {
        return this.totalPages;
    }

    @NotNull
    public final List<Integer> getGrid() {
        return this.grid;
    }

    public final boolean getHasCosmetics() {
        return this.hasCosmetics;
    }

    public final boolean isViewingCosmetics() {
        return this.isViewingCosmetics;
    }

    public final int getPanelWidth() {
        return this.panelWidth;
    }

    public final void setPanelWidth(int n) {
        this.panelWidth = n;
    }

    private static /* synthetic */ void getThiss$annotations() {
    }

    public final void curios$init(@NotNull InventorioScreenHandler $this$curios_u24init) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24init), (String)"<this>");
        this.curios$resetSlots($this$curios_u24init);
    }

    public final void curios$resetSlots(@NotNull InventorioScreenHandler $this$curios_u24resetSlots) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24resetSlots), (String)"<this>");
        this.curios$setPage($this$curios_u24resetSlots, this.currentPage);
    }

    public final void curios$setPage(@NotNull InventorioScreenHandler $this$curios_u24setPage, int page) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24setPage), (String)"<this>");
        NonNullList nonNullList = $this$curios_u24setPage.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        RandomStuff.subList((List)nonNullList, this.curiosSlotRange).clear();
        NonNullList<ItemStack> nonNullList2 = this.thiss.getTrackedStacks();
        Intrinsics.checkNotNullExpressionValue(nonNullList2, (String)"getTrackedStacks(...)");
        RandomStuff.subList((List)nonNullList2, this.curiosSlotRange).clear();
        NonNullList<ItemStack> nonNullList3 = this.thiss.getPreviousTrackedStacks();
        Intrinsics.checkNotNullExpressionValue(nonNullList3, (String)"getPreviousTrackedStacks(...)");
        RandomStuff.subList((List)nonNullList3, this.curiosSlotRange).clear();
        this.panelWidth = 0;
        int visibleSlots = 0;
        Object object = CuriosConfig.SERVER.maxSlotsPerPage.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int maxSlotsPerPage = ((Number)object).intValue();
        int startingIndex = page * maxSlotsPerPage;
        int columns = 0;
        int curiosSlotStart = $this$curios_u24setPage.slots.size();
        if (this.curiosHandler != null) {
            visibleSlots = this.curiosHandler.getVisibleSlots();
            int slotsOnPage = Math.min(maxSlotsPerPage, visibleSlots - startingIndex);
            int calculatedColumns = (int)Math.ceil((double)slotsOnPage / (double)8);
            Object object2 = CuriosConfig.SERVER.minimumColumns.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            int n = ((Number)object2).intValue();
            int minimumColumns = Math.min(slotsOnPage, n);
            columns = RangesKt.coerceIn((int)calculatedColumns, (int)minimumColumns, (int)8);
            this.panelWidth = 14 + 18 * columns;
            Map curioMap = this.curiosHandler.getCurios();
            this.totalPages = (int)Math.ceil((double)visibleSlots / (double)maxSlotsPerPage);
            int index = 0;
            int yOffset = 8;
            if (this.totalPages > 1) {
                yOffset += 8;
            }
            int currentColumn = 1;
            int currentRow = 1;
            int slots = 0;
            this.grid.clear();
            this.proxySlots.clear();
            int currentPage = 0;
            int endingIndex = startingIndex + maxSlotsPerPage;
            for (Map.Entry entry : curioMap.entrySet()) {
                String identifier = (String)entry.getKey();
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                boolean isCosmetic = false;
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (stacksHandler.hasCosmetic()) {
                    this.hasCosmetics = true;
                    if (this.isViewingCosmetics) {
                        isCosmetic = true;
                        stackHandler = stacksHandler.getCosmeticStacks();
                    }
                }
                if (!stacksHandler.isVisible()) continue;
                int n2 = stackHandler.getSlots();
                for (int i = 0; i < n2; ++i) {
                    boolean bl = startingIndex <= index ? index < endingIndex : false;
                    if (bl) {
                        this.thiss.callAddSlot((Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), (List)stacksHandler.getActiveStates(), stacksHandler.canToggleRendering(), isCosmetic, isCosmetic));
                        if (this.grid.size() < currentColumn) {
                            this.grid.add(1);
                        } else {
                            this.grid.set(currentColumn - 1, ((Number)this.grid.get(currentColumn - 1)).intValue() + 1);
                        }
                        if (currentColumn == columns) {
                            currentColumn = 1;
                            v6 = currentRow++;
                        } else {
                            v6 = currentColumn++;
                        }
                    } else {
                        this.proxySlots.add(new ProxySlot(currentPage, (Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), (List)stacksHandler.getActiveStates(), stacksHandler.canToggleRendering(), isCosmetic, isCosmetic)));
                    }
                    if (++slots >= maxSlotsPerPage) {
                        slots = 0;
                        ++currentPage;
                    }
                    ++index;
                }
            }
            if (!this.isLocalWorld) {
                InventorioNetworking inventorioNetworking = InventorioNetworking.Companion.getInstance();
                Player player = this.player;
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
                inventorioNetworking.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketPage($this$curios_u24setPage.containerId, page));
            }
        }
        this.currentPage = page;
        this.curiosSlotRange = RangesKt.until((int)curiosSlotStart, (int)$this$curios_u24setPage.slots.size());
    }

    public final void curios$toggleCosmetics(@NotNull InventorioScreenHandler $this$curios_u24toggleCosmetics) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24toggleCosmetics), (String)"<this>");
        this.isViewingCosmetics = !this.isViewingCosmetics;
        this.curios$resetSlots($this$curios_u24toggleCosmetics);
    }

    public final void curios$setStackInSlot(@NotNull InventorioScreenHandler $this$curios_u24setStackInSlot, int slot, @NotNull CallbackInfo ci) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24setStackInSlot), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        if ($this$curios_u24setStackInSlot.slots.size() <= slot) {
            ci.cancel();
        }
    }

    public final void curios$quickMove(@NotNull InventorioScreenHandler $this$curios_u24quickMove, @NotNull Player player, int sourceIndex, @NotNull CallbackInfoReturnable<ItemStack> cir) {
        block6: {
            ItemStack stack;
            block8: {
                IntRange availableDeepPocketsRange;
                int n;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24quickMove), (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                    Intrinsics.checkNotNullParameter(cir, (String)"cir");
                    Object object = $this$curios_u24quickMove.slots.get(sourceIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    Slot slot = (Slot)object;
                    if (!slot.hasItem()) break block6;
                    stack = slot.getItem();
                    IntRange intRange = this.curiosSlotRange;
                    n = intRange.getFirst();
                    boolean bl = sourceIndex <= intRange.getLast() ? n <= sourceIndex : false;
                    if (!bl) break block7;
                    availableDeepPocketsRange = $this$curios_u24quickMove.getAvailableDeepPocketsRange();
                    AbstractContainerMenu abstractContainerMenu = (AbstractContainerMenu)$this$curios_u24quickMove;
                    Intrinsics.checkNotNull((Object)stack);
                    cir.setReturnValue((Object)(!RandomStuff.insertItem$default(abstractContainerMenu, stack, InventorioScreenHandler.mainInventoryRange, false, 4, null) && (availableDeepPocketsRange.isEmpty() || !RandomStuff.insertItem$default((AbstractContainerMenu)$this$curios_u24quickMove, stack, availableDeepPocketsRange, false, 4, null)) ? ItemStack.EMPTY : stack));
                    break block6;
                }
                availableDeepPocketsRange = InventorioScreenHandler.mainInventoryRange;
                n = availableDeepPocketsRange.getFirst();
                if (sourceIndex <= availableDeepPocketsRange.getLast() ? n <= sourceIndex : false) break block8;
                availableDeepPocketsRange = InventorioScreenHandler.deepPocketsRange;
                n = availableDeepPocketsRange.getFirst();
                boolean bl = sourceIndex <= availableDeepPocketsRange.getLast() ? n <= sourceIndex : false;
                if (!bl) break block6;
            }
            Map map = CuriosApi.getItemStackSlots((ItemStack)stack, (Level)player.level());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getItemStackSlots(...)");
            if (!map.isEmpty()) {
                AbstractContainerMenu abstractContainerMenu = (AbstractContainerMenu)$this$curios_u24quickMove;
                Intrinsics.checkNotNull((Object)stack);
                if (!RandomStuff.insertItem$default(abstractContainerMenu, stack, this.curiosSlotRange, false, 4, null)) {
                    int page = this.findAvailableSlot(stack);
                    if (page != 1) {
                        this.moveToPage = page;
                        this.moveFromIndex = sourceIndex;
                    }
                    cir.setReturnValue((Object)ItemStack.EMPTY);
                }
            }
        }
    }

    private final int findAvailableSlot(ItemStack stack) {
        int result = -1;
        if (stack.isStackable()) {
            for (ProxySlot proxySlot : this.proxySlots) {
                int maxSize;
                int j;
                Slot slot = proxySlot.getSlot();
                ItemStack itemStack = slot.getItem();
                Intrinsics.checkNotNull((Object)itemStack);
                if (!RandomStuff.isNotEmpty(itemStack) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || (j = itemStack.getCount() + stack.getCount()) > (maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize())) && itemStack.getCount() >= maxSize) continue;
                result = proxySlot.getPage();
                break;
            }
        }
        if (RandomStuff.isNotEmpty(stack) && result == -1) {
            for (ProxySlot proxySlot : this.proxySlots) {
                Slot slot1 = proxySlot.getSlot();
                ItemStack itemStack1 = slot1.getItem();
                if (!itemStack1.isEmpty() || !slot1.mayPlace(stack)) continue;
                result = proxySlot.getPage();
                break;
            }
        }
        return result;
    }

    public final void curios$nextPage(@NotNull InventorioScreenHandler $this$curios_u24nextPage) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24nextPage), (String)"<this>");
        this.curios$setPage($this$curios_u24nextPage, Math.min(this.currentPage + 1, this.totalPages - 1));
    }

    public final void curios$prevPage(@NotNull InventorioScreenHandler $this$curios_u24prevPage) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24prevPage), (String)"<this>");
        this.curios$setPage($this$curios_u24prevPage, Math.max(this.currentPage - 1, 0));
    }

    public final void curios$checkQuickMove(@NotNull InventorioScreenHandler $this$curios_u24checkQuickMove) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24checkQuickMove), (String)"<this>");
        if (this.moveToPage != -1) {
            this.curios$setPage($this$curios_u24checkQuickMove, this.moveToPage);
            $this$curios_u24checkQuickMove.quickMoveStack(this.player, this.moveFromIndex);
            this.moveToPage = -1;
            if (!this.isLocalWorld) {
                InventorioNetworking inventorioNetworking = InventorioNetworking.Companion.getInstance();
                Player player = this.player;
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
                inventorioNetworking.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketQuickMove($this$curios_u24checkQuickMove.containerId, this.moveFromIndex));
            }
        }
    }

    public final void curios$onSlotClick(@NotNull InventorioScreenHandler $this$curios_u24onSlotClick, int slotId, @NotNull ClickType clickType, @NotNull Player player, @NotNull CallbackInfo ci) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$curios_u24onSlotClick), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        Slot slot = $this$curios_u24onSlotClick.getSlot(slotId);
        if (slot instanceof CurioSlot && clickType == ClickType.CLONE && player.hasInfiniteMaterials() && $this$curios_u24onSlotClick.getCarried().isEmpty()) {
            ItemStack stack = ((CurioSlot)slot).getSlotExtension().getCloneStack(((CurioSlot)slot).getSlotContext(), ((CurioSlot)slot).getItem());
            Intrinsics.checkNotNull((Object)stack);
            if (RandomStuff.isNotEmpty(stack)) {
                $this$curios_u24onSlotClick.setCarried(stack.copyWithCount(stack.getMaxStackSize()));
            }
            ci.cancel();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lde/rubixdev/inventorio/integration/curios/InventorioScreenHandlerMixinHelper$ProxySlot;", "", "", "page", "Lnet/minecraft/world/inventory/Slot;", "slot", "<init>", "(ILnet/minecraft/world/inventory/Slot;)V", "component1", "()I", "component2", "()Lnet/minecraft/world/inventory/Slot;", "copy", "(ILnet/minecraft/world/inventory/Slot;)Lde/rubixdev/inventorio/integration/curios/InventorioScreenHandlerMixinHelper$ProxySlot;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getPage", "Lnet/minecraft/world/inventory/Slot;", "getSlot", "inventorio-mc1.21.1-neoforge"})
    private static final class ProxySlot {
        private final int page;
        @NotNull
        private final Slot slot;

        public ProxySlot(int page, @NotNull Slot slot) {
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            this.page = page;
            this.slot = slot;
        }

        public final int getPage() {
            return this.page;
        }

        @NotNull
        public final Slot getSlot() {
            return this.slot;
        }

        public final int component1() {
            return this.page;
        }

        @NotNull
        public final Slot component2() {
            return this.slot;
        }

        @NotNull
        public final ProxySlot copy(int page, @NotNull Slot slot) {
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            return new ProxySlot(page, slot);
        }

        public static /* synthetic */ ProxySlot copy$default(ProxySlot proxySlot, int n, Slot slot, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = proxySlot.page;
            }
            if ((n2 & 2) != 0) {
                slot = proxySlot.slot;
            }
            return proxySlot.copy(n, slot);
        }

        @NotNull
        public String toString() {
            return "ProxySlot(page=" + this.page + ", slot=" + this.slot + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.page);
            result = result * 31 + this.slot.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProxySlot)) {
                return false;
            }
            ProxySlot proxySlot = (ProxySlot)other;
            if (this.page != proxySlot.page) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.slot, (Object)proxySlot.slot);
        }
    }
}

