/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.rubixdev.inventorio.client.control.InventorioKeyHandler;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class}, priority=-5000)
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public Player player;

    @Inject(method={"replaceWith(Lnet/minecraft/world/entity/player/Inventory;)V"}, at={@At(value="RETURN")})
    private void inventorioClonePlayerInventory(Inventory sourceInventory, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.player, thisAddon -> MixinHelpers.withInventoryAddon(sourceInventory.player, thisAddon::cloneFrom));
    }

    @Inject(method={"getSelected()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetMainHandStack(CallbackInfoReturnable<ItemStack> cir) {
        MixinHelpers.withInventoryAddon(this.player, inventorioAddon -> {
            ItemStack mainHandStack = inventorioAddon.getDisplayedMainHandStack();
            if (mainHandStack != null) {
                cir.setReturnValue((Object)mainHandStack);
            }
        });
    }

    @Inject(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetBlockBreakingSpeed(BlockState block, CallbackInfoReturnable<Float> cir) {
        MixinHelpers.withInventoryAddon(this.player, inventorioAddon -> cir.setReturnValue((Object)Float.valueOf(inventorioAddon.getMiningSpeedMultiplier(block))));
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioInsertSimilarStackIntoAddon(int slot, ItemStack originalStack, CallbackInfoReturnable<Boolean> cir) {
        MixinHelpers.withInventoryAddon(this.player, inventorioAddon -> {
            if (slot == -1 && inventorioAddon != null && inventorioAddon.insertOnlySimilarStack(originalStack)) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @ModifyReturnValue(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean inventorioInsertStackIntoAddon(boolean original, int slot, ItemStack originalStack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.player, addon -> slot == -1 && addon.insertStackIntoEmptySlot(originalStack)));
    }

    @Inject(method={"removeItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioRemoveOneFromAddon(ItemStack stack, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.player, inventorioAddon -> {
            if (inventorioAddon != null && inventorioAddon.removeOne(stack)) {
                ci.cancel();
            }
        });
    }

    @Inject(method={"dropAll()V"}, at={@At(value="RETURN")})
    private void inventorioDropAllFromAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.player, PlayerInventoryExtension::dropAll);
    }

    @Inject(method={"clearContent()V"}, at={@At(value="RETURN")})
    private void inventorioClearAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.player, SimpleContainer::clearContent);
    }

    @Inject(method={"swapPaint(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void inventorioScrollInHotbar(double scrollAmount, CallbackInfo ci) {
        if (InventorioKeyHandler.INSTANCE.scrollInHotbar(this.player, scrollAmount)) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"contains(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, ItemStack stack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.player, addon -> addon.contains(stack)));
    }

    @ModifyReturnValue(method={"contains(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, TagKey<Item> tag) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.player, addon -> addon.contains(tag)));
    }
}

