/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import de.rubixdev.inventorio.client.control.InventorioKeyHandler;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class}, priority=9999)
public class MinecraftClientMixin {
    @Shadow
    public LocalPlayer player;
    @Shadow
    @Nullable
    public Screen screen;

    @WrapOperation(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/tutorial/Tutorial;onOpenInventory()V"))})
    private void inventorioOpenReplacingScreen(Minecraft instance, Screen old, Operation<Void> original) {
        if (InventorioScreen.shouldOpenVanillaInventory || instance.gameMode != null && instance.gameMode.hasInfiniteItems()) {
            original.call(new Object[]{instance, old});
        } else {
            InventorioNetworking.getInstance().c2sOpenInventorioScreen();
        }
    }

    @WrapOperation(method={"handleKeybinds()V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Inventory;selected:I")})
    private void inventorioHandleHotbarSlotSelection(Inventory instance, int value, Operation<Integer> original, @Local int i) {
        if (!InventorioKeyHandler.INSTANCE.handleSegmentedHotbarSlotSelection(instance, i)) {
            original.call(new Object[]{instance, value});
        }
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="NEW", target="(Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;")}, cancellable=true)
    private void inventorioPreventOffhandSwapForDisplayTool(CallbackInfo ci) {
        ci.cancel();
        InventorioNetworking.getInstance().c2sSwapItemsInHands();
    }

    @Redirect(method={"startUseItem()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/InteractionHand;values()[Lnet/minecraft/world/InteractionHand;"))
    private InteractionHand[] inventorioDoItemUse() {
        if (this.player == null) {
            return new InteractionHand[0];
        }
        return InventorioKeyHandler.INSTANCE.handleItemUsage((Player)this.player);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;screen:Lnet/minecraft/client/gui/screens/Screen;", opcode=181)}, cancellable=true)
    private void seamlessScreenTransition(Screen screen, CallbackInfo ci) {
        if (InventorioScreen.isSwappingInvScreens && screen == null && (this.screen instanceof InventorioScreen || this.screen instanceof InventoryScreen)) {
            ci.cancel();
        }
    }
}

