/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin.neoforge.curios;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.integration.curios.ICuriosScreen;
import de.rubixdev.inventorio.util.CuriosTester;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.common.inventory.CurioSlot;

@Restriction(require={@Condition(value="curios"), @Condition(type=Condition.Type.TESTER, tester=CuriosTester.class)})
@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin
extends Screen {
    protected HandledScreenMixin(Component title) {
        super(title);
    }

    @ModifyReturnValue(method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, at={@At(value="RETURN")})
    private boolean dontRenderCuriosWhenClosed(boolean original, Slot slot) {
        HandledScreenMixin handledScreenMixin = this;
        if (handledScreenMixin instanceof ICuriosScreen) {
            ICuriosScreen curiosScreen = (ICuriosScreen)((Object)handledScreenMixin);
            if (slot instanceof CurioSlot && !curiosScreen.getInventorio$isCuriosOpen()) {
                return false;
            }
        }
        return original;
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontRenderCuriosWhenClosed(GuiGraphics context, Slot slot, CallbackInfo ci) {
        HandledScreenMixin handledScreenMixin = this;
        if (handledScreenMixin instanceof ICuriosScreen) {
            ICuriosScreen curiosScreen = (ICuriosScreen)((Object)handledScreenMixin);
            if (slot instanceof CurioSlot && !curiosScreen.getInventorio$isCuriosOpen()) {
                ci.cancel();
            }
        }
    }

    @ModifyVariable(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;getCarried()Lnet/minecraft/world/item/ItemStack;", ordinal=0))
    protected ItemStack drawSlot(ItemStack itemstack, GuiGraphics drawContext, Slot slot) {
        if (this instanceof InventorioScreen && slot instanceof CurioSlot) {
            CurioSlot curioSlot = (CurioSlot)slot;
            return curioSlot.getSlotExtension().getDisplayStack(curioSlot.getSlotContext(), itemstack);
        }
        return itemstack;
    }
}

