/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin.neoforge.curios;

import de.rubixdev.inventorio.integration.curios.ICuriosContainer;
import de.rubixdev.inventorio.integration.curios.InventorioScreenHandlerMixinHelper;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.util.CuriosTester;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.type.ICuriosMenu;

@Restriction(require={@Condition(value="curios"), @Condition(type=Condition.Type.TESTER, tester=CuriosTester.class)})
@Mixin(value={InventorioScreenHandler.class})
public abstract class InventorioScreenHandlerMixin
extends RecipeBookMenu<CraftingInput, CraftingRecipe>
implements ICuriosContainer,
ICuriosMenu {
    @Unique
    private final InventorioScreenHandler thiz = (InventorioScreenHandler)((Object)this);
    @Unique
    private InventorioScreenHandlerMixinHelper helper;

    public InventorioScreenHandlerMixin(MenuType<?> arg, int i) {
        super(arg, i);
    }

    public void resetSlots() {
        this.inventorio$resetSlots();
    }

    @Override
    public void inventorio$resetSlots() {
        this.helper.curios$resetSlots(this.thiz);
    }

    @Override
    public void inventorio$setPage(int page) {
        this.helper.curios$setPage(this.thiz, page);
    }

    @Override
    public void inventorio$toggleCosmetics() {
        this.helper.curios$toggleCosmetics(this.thiz);
    }

    @Override
    public void inventorio$nextPage() {
        this.helper.curios$nextPage(this.thiz);
    }

    @Override
    public void inventorio$prevPage() {
        this.helper.curios$prevPage(this.thiz);
    }

    @Override
    public void inventorio$checkQuickMove() {
        this.helper.curios$checkQuickMove(this.thiz);
    }

    @Override
    public int getInventorio$currentPage() {
        return this.helper.getCurrentPage();
    }

    @Override
    public int getInventorio$totalPages() {
        return this.helper.getTotalPages();
    }

    @Override
    @NotNull
    public List<Integer> getInventorio$grid() {
        return this.helper.getGrid();
    }

    @Override
    public boolean getInventorio$hasCosmetics() {
        return this.helper.getHasCosmetics();
    }

    @Override
    public boolean getInventorio$isViewingCosmetics() {
        return this.helper.isViewingCosmetics();
    }

    @Override
    public int getInventorio$panelWidth() {
        return this.helper.getPanelWidth();
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;)V"}, at={@At(value="RETURN")})
    private void curios$init(int syncId, Inventory inventory, CallbackInfo ci) {
        this.helper = new InventorioScreenHandlerMixinHelper(this.thiz);
        this.helper.curios$init(this.thiz);
    }

    @Inject(method={"setItem(IILnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void curios$setStackInSlot(int slot, int revision, ItemStack stack, CallbackInfo ci) {
        this.helper.curios$setStackInSlot(this.thiz, slot, ci);
    }

    @Inject(method={"quickMoveStack(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void curios$quickMove(Player player, int sourceIndex, CallbackInfoReturnable<ItemStack> cir) {
        this.helper.curios$quickMove(this.thiz, player, sourceIndex, cir);
    }

    @Inject(method={"clicked(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void curios$onSlotClick(int slotIndex, int clickDelta, ClickType actionType, Player player, CallbackInfo ci) {
        this.helper.curios$onSlotClick(this.thiz, slotIndex, actionType, player, ci);
    }
}

