/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player;

import de.rubixdev.inventorio.ScreenTypeProvider;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.mixin.accessor.CraftingScreenHandlerAccessor;
import de.rubixdev.inventorio.mixin.accessor.SlotAccessor;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import de.rubixdev.inventorio.slot.ArmorSlot;
import de.rubixdev.inventorio.slot.BlockedSlot;
import de.rubixdev.inventorio.slot.DeepPocketsSlot;
import de.rubixdev.inventorio.slot.ToolBeltSlot;
import de.rubixdev.inventorio.util.GeneralConstants;
import de.rubixdev.inventorio.util.IntProgressionIndices;
import de.rubixdev.inventorio.util.IntProgressionIterator;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.RangeIteratorKt;
import de.rubixdev.inventorio.util.UIConstants;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 [2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001[B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0018\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0018H\u0003\u00a2\u0006\u0004\b\"\u0010!J\u000f\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020#H\u0002\u00a2\u0006\u0004\b&\u0010%J\r\u0010'\u001a\u00020#\u00a2\u0006\u0004\b'\u0010%J\u000f\u0010(\u001a\u00020#H\u0002\u00a2\u0006\u0004\b(\u0010%J\r\u0010)\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u00100\u001a\u00020\u00182\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b2\u0010!J\u001f\u00105\u001a\u00020\u001d2\u000e\u00104\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u000103H\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00108\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u000207H\u0016\u00a2\u0006\u0004\b8\u00109J\u0017\u0010:\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010<\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010,\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b,\u0010@J\u000f\u0010A\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bA\u0010*J\u000f\u0010B\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bB\u0010*J\u000f\u0010C\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bC\u0010*J\u000f\u0010D\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bD\u0010*J\u000f\u0010F\u001a\u00020EH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010H\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bH\u0010IJ)\u0010K\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\bK\u0010LR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010M\u001a\u0004\bN\u0010OR\u0017\u0010Q\u001a\u00020P8\u0006\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u0014\u0010Y\u001a\u00020X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010Z\u00a8\u0006\\"}, d2={"Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "Lnet/minecraft/world/inventory/RecipeBookMenu;", "Lnet/minecraft/world/item/crafting/CraftingInput;", "Lnet/minecraft/world/item/crafting/CraftingRecipe;", "", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "sourceIndex", "Lnet/minecraft/world/item/ItemStack;", "quickMove", "(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;", "stackDynamic", "quickMoveInner", "(Lnet/minecraft/world/entity/player/Player;ILnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "slotIndex", "clickData", "Lnet/minecraft/world/inventory/ClickType;", "actionType", "playerEntity", "", "onSlotClick", "(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/inventory/Slot;", "sourceSlot", "", "tryTransferToUtilityBeltSlot", "(Lnet/minecraft/world/inventory/Slot;)Z", "updateDeepPocketsCapacity", "()V", "refreshSlotPositions", "Lkotlin/ranges/IntRange;", "getAvailableUtilityBeltRange", "()Lkotlin/ranges/IntRange;", "getUnavailableUtilityBeltRange", "getAvailableDeepPocketsRange", "getUnavailableDeepPocketsRange", "getToolBeltSlotCount", "()I", "index", "canInsertIntoSlot", "(I)Z", "Lnet/minecraft/world/entity/player/StackedContents;", "finder", "populateRecipeFinder", "(Lnet/minecraft/world/entity/player/StackedContents;)V", "clearCraftingSlots", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "recipe", "matches", "(Lnet/minecraft/world/item/crafting/RecipeHolder;)Z", "Lnet/minecraft/world/Container;", "onContentChanged", "(Lnet/minecraft/world/Container;)V", "onClosed", "(Lnet/minecraft/world/entity/player/Player;)V", "canUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "stack", "slot", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;)Z", "getCraftingResultSlotIndex", "getCraftingWidth", "getCraftingHeight", "getCraftingSlotCount", "Lnet/minecraft/world/inventory/RecipeBookType;", "getCategory", "()Lnet/minecraft/world/inventory/RecipeBookType;", "getSlot", "(I)Lnet/minecraft/world/inventory/Slot;", "revision", "setStackInSlot", "(IILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Inventory;", "getInventory", "()Lnet/minecraft/world/entity/player/Inventory;", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "inventoryAddon", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "getInventoryAddon", "()Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "Lnet/minecraft/world/inventory/TransientCraftingContainer;", "craftingInput", "Lnet/minecraft/world/inventory/TransientCraftingContainer;", "Lnet/minecraft/world/inventory/ResultContainer;", "craftingResult", "Lnet/minecraft/world/inventory/ResultContainer;", "Companion", "inventorio-mc1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nInventorioScreenHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventorioScreenHandler.kt\nde/rubixdev/inventorio/player/InventorioScreenHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,462:1\n216#2,2:463\n*S KotlinDebug\n*F\n+ 1 InventorioScreenHandler.kt\nde/rubixdev/inventorio/player/InventorioScreenHandler\n*L\n123#1:463,2\n*E\n"})
public final class InventorioScreenHandler
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final PlayerInventoryAddon inventoryAddon;
    @NotNull
    private final TransientCraftingContainer craftingInput;
    @NotNull
    private final ResultContainer craftingResult;
    @JvmField
    @NotNull
    public static final IntRange craftingGridRange = RangeIteratorKt.expandBy(0, 5);
    @JvmField
    @NotNull
    public static final IntRange armorSlotsRange = RangeIteratorKt.expandBy(craftingGridRange.getLast() + 1, 4);
    @JvmField
    @NotNull
    public static final IntRange mainInventoryRange = RangeIteratorKt.expandBy(armorSlotsRange.getLast() + 1, 36);
    @JvmField
    @NotNull
    public static final IntRange deepPocketsRange = RangeIteratorKt.expandBy(mainInventoryRange.getLast() + 1, 27);
    @JvmField
    @NotNull
    public static final IntRange utilityBeltRange = RangeIteratorKt.expandBy(deepPocketsRange.getLast() + 1, 8);
    @JvmField
    @NotNull
    public static final IntRange toolBeltRange = RangeIteratorKt.expandBy(utilityBeltRange.getLast() + 1, PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_21_1_neoforge().size());
    @JvmField
    @NotNull
    public static final IntRange mainInventoryWithoutHotbarRange = new IntRange(mainInventoryRange.getFirst(), mainInventoryRange.getLast() - 9);
    @JvmField
    @NotNull
    public static final IntRange hotbarRange = new IntRange(mainInventoryWithoutHotbarRange.getLast() + 1, mainInventoryRange.getLast());
    @NotNull
    private static final Map<ResourceLocation, Consumer<InventorioScreenHandler>> openConsumers = new LinkedHashMap();
    @NotNull
    private static final EquipmentSlot[] armorSlots;

    public InventorioScreenHandler(int syncId, @NotNull Inventory inventory) {
        int relativeIndex;
        int absoluteIndex;
        Object object;
        int relativeIndex2;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        super(ScreenTypeProvider.Companion.getINSTANCE().getScreenHandlerType(), syncId);
        this.inventory = inventory;
        Player player = this.inventory.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        PlayerInventoryAddon playerInventoryAddon = PlayerInventoryAddon.Companion.getInventoryAddon(player);
        Intrinsics.checkNotNull((Object)((Object)playerInventoryAddon));
        this.inventoryAddon = playerInventoryAddon;
        this.craftingInput = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
        this.craftingResult = new ResultContainer();
        if (GlobalSettings.allow2x2CraftingGrid.getBoolValue()) {
            this.addSlot((Slot)new ResultSlot(this.inventory.player, (CraftingContainer)this.craftingInput, (Container)this.craftingResult, 0, 174, 28));
            for (i = 0; i < 4; ++i) {
                this.addSlot(new Slot((Container)this.craftingInput, i, 118 + i % 2 * 18, 18 + i / 2 * 18));
            }
        } else {
            this.addSlot(new BlockedSlot((Container)this.inventory, 0, 174, 28));
            for (i = 0; i < 4; ++i) {
                this.addSlot(new BlockedSlot((Container)this.craftingInput, i, 118 + i % 2 * 18, 18 + i / 2 * 18));
            }
        }
        IntProgressionIterator i = RangeIteratorKt.withRelativeIndex((IntProgression)armorSlotsRange);
        while (((Iterator)i).hasNext()) {
            relativeIndex2 = i.next().component2();
            Container container = (Container)this.inventory;
            Player player2 = this.inventory.player;
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
            this.addSlot(new ArmorSlot(container, (LivingEntity)player2, armorSlots[relativeIndex2], 39 - relativeIndex2, 8, 8 + relativeIndex2 * 18));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)mainInventoryWithoutHotbarRange);
        while (((Iterator)i).hasNext()) {
            relativeIndex2 = i.next().component2();
            this.addSlot(new Slot((Container)this.inventory, relativeIndex2 + 9, 8 + relativeIndex2 % 9 * 18, 84 + relativeIndex2 / 9 * 18));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)hotbarRange);
        while (((Iterator)i).hasNext()) {
            relativeIndex2 = i.next().component2();
            this.addSlot(new Slot((Container)this.inventory, relativeIndex2, 8 + relativeIndex2 * 18, 142));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE);
        while (((Iterator)i).hasNext()) {
            object = i.next();
            absoluteIndex = ((IntProgressionIndices)object).component1();
            relativeIndex = ((IntProgressionIndices)object).component2();
            this.addSlot(new DeepPocketsSlot((Container)this.inventoryAddon, absoluteIndex, UIConstants.SLOT_INVENTORY_DEEP_POCKETS.x + relativeIndex % 9 * 18, UIConstants.SLOT_INVENTORY_DEEP_POCKETS.y + relativeIndex / 9 * 18));
        }
        i = RangeIteratorKt.withRelativeIndex((IntProgression)GeneralConstants.INVENTORY_ADDON_UTILITY_BELT_RANGE);
        while (((Iterator)i).hasNext()) {
            object = i.next();
            absoluteIndex = ((IntProgressionIndices)object).component1();
            relativeIndex = ((IntProgressionIndices)object).component2();
            this.addSlot(new DeepPocketsSlot((Container)this.inventoryAddon, absoluteIndex, UIConstants.SLOT_UTILITY_BELT_COLUMN_1.x + 18 * (relativeIndex / 4), UIConstants.SLOT_UTILITY_BELT_COLUMN_1.y + 18 * (relativeIndex % 4)));
        }
        int deepPocketsRowCount = this.inventoryAddon.getDeepPocketsRowCount();
        object = ((Iterable)PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_21_1_neoforge()).iterator();
        absoluteIndex = 0;
        while (object.hasNext()) {
            relativeIndex = absoluteIndex++;
            ToolBeltSlotTemplate toolBeltTemplate = (ToolBeltSlotTemplate)object.next();
            this.addSlot(new ToolBeltSlot(toolBeltTemplate, this.inventoryAddon, relativeIndex + GeneralConstants.INVENTORY_ADDON_TOOL_BELT_INDEX_OFFSET, ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).x, ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).y));
        }
        this.updateDeepPocketsCapacity();
        Map<ResourceLocation, Consumer<InventorioScreenHandler>> $this$forEach$iv = openConsumers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>> element$iv;
            Map.Entry<ResourceLocation, Consumer<InventorioScreenHandler>> it = element$iv = iterator.next();
            boolean bl = false;
            try {
                it.getValue().accept(this);
            }
            catch (Throwable e) {
                RandomStuff.getLogger().error("Inventory Screen Handler Open Consumer '" + it.getKey() + "' has failed: ", e);
            }
        }
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final PlayerInventoryAddon getInventoryAddon() {
        return this.inventoryAddon;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int sourceIndex) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = this.slots.get(sourceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot sourceSlot = (Slot)object;
        ItemStack stackDynamic = sourceSlot.getItem();
        Intrinsics.checkNotNull((Object)stackDynamic);
        ItemStack stackStatic = this.quickMoveInner(player, sourceIndex, stackDynamic);
        if (RandomStuff.isNotEmpty(stackStatic)) {
            if (stackDynamic.isEmpty()) {
                sourceSlot.setByPlayer(ItemStack.EMPTY);
            } else {
                sourceSlot.setChanged();
            }
            if (stackDynamic.getCount() == stackStatic.getCount()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            sourceSlot.onTake(player, stackDynamic);
        }
        return stackStatic;
    }

    private final ItemStack quickMoveInner(Player player, int sourceIndex, ItemStack stackDynamic) {
        IntRange availableDeepPocketsRange;
        ItemStack stackStatic;
        block18: {
            block17: {
                stackStatic = stackDynamic.copy();
                availableDeepPocketsRange = this.getAvailableDeepPocketsRange();
                IntRange intRange = mainInventoryRange;
                int n = intRange.getFirst();
                if (sourceIndex <= intRange.getLast() ? n <= sourceIndex : false) break block17;
                int n2 = availableDeepPocketsRange.getFirst();
                boolean bl = sourceIndex <= availableDeepPocketsRange.getLast() ? n2 <= sourceIndex : false;
                if (!bl) break block18;
            }
            if (player.getEquipmentSlotForItem(stackStatic).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, armorSlotsRange, false, 4, null)) {
                this.updateDeepPocketsCapacity();
                Intrinsics.checkNotNull((Object)stackStatic);
                return stackStatic;
            }
            if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, toolBeltRange, false, 4, null)) {
                Intrinsics.checkNotNull((Object)stackStatic);
                return stackStatic;
            }
        }
        int n = sourceIndex;
        IntRange intRange = hotbarRange;
        int n3 = intRange.getFirst();
        boolean bl = n <= intRange.getLast() ? n3 <= n : false;
        if (bl) {
            if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryWithoutHotbarRange, false, 4, null) || !availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null)) {
                Intrinsics.checkNotNull((Object)stackStatic);
                return stackStatic;
            }
        } else {
            intRange = mainInventoryWithoutHotbarRange;
            n3 = intRange.getFirst();
            boolean bl2 = n <= intRange.getLast() ? n3 <= n : false;
            if (bl2) {
                if (!availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null) || RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, hotbarRange, false, 4, null)) {
                    Intrinsics.checkNotNull((Object)stackStatic);
                    return stackStatic;
                }
            } else {
                int n4 = availableDeepPocketsRange.getFirst();
                boolean bl3 = n <= availableDeepPocketsRange.getLast() ? n4 <= n : false;
                if (bl3) {
                    if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryRange, false, 4, null)) {
                        Intrinsics.checkNotNull((Object)stackStatic);
                        return stackStatic;
                    }
                } else if (RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, mainInventoryRange, false, 4, null) || !availableDeepPocketsRange.isEmpty() && RandomStuff.insertItem$default((AbstractContainerMenu)this, stackDynamic, availableDeepPocketsRange, false, 4, null)) {
                    IntRange intRange2 = craftingGridRange;
                    n3 = intRange2.getFirst();
                    boolean bl4 = sourceIndex <= intRange2.getLast() ? n3 <= sourceIndex : false;
                    if (bl4) {
                        this.slotsChanged((Container)this.craftingInput);
                        this.slotsChanged((Container)this.craftingResult);
                    }
                    Intrinsics.checkNotNull((Object)stackStatic);
                    return stackStatic;
                }
            }
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void clicked(int slotIndex, int clickData, @NotNull ClickType actionType, @NotNull Player playerEntity) {
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        super.clicked(slotIndex, clickData, actionType, playerEntity);
        IntRange intRange = armorSlotsRange;
        int n = intRange.getFirst();
        boolean bl = slotIndex <= intRange.getLast() ? n <= slotIndex : false;
        if (bl) {
            this.updateDeepPocketsCapacity();
        } else {
            intRange = utilityBeltRange;
            n = intRange.getFirst();
            boolean bl2 = slotIndex <= intRange.getLast() ? n <= slotIndex : false;
            if (bl2 && this.inventoryAddon.getSelectedUtilityStack().isEmpty()) {
                this.inventoryAddon.setSelectedUtility(slotIndex - utilityBeltRange.getFirst());
            }
        }
    }

    public final boolean tryTransferToUtilityBeltSlot(@Nullable Slot sourceSlot) {
        if (sourceSlot == null) {
            return false;
        }
        ItemStack itemStackDynamic = sourceSlot.getItem();
        IntRange beltRange = this.getAvailableUtilityBeltRange();
        int n = beltRange.getFirst();
        int n2 = beltRange.getLast();
        int n3 = sourceSlot.index;
        if (!(n <= n3 ? n3 <= n2 : false)) {
            if (this.moveItemStackTo(itemStackDynamic, beltRange.getFirst(), beltRange.getLast() + 1, false)) {
                if (this.inventoryAddon.getPlayer().level().isClientSide) {
                    InventorioNetworking.Companion.getInstance().c2sMoveItemToUtilityBelt(sourceSlot.index);
                }
                return true;
            }
            return false;
        }
        IntRange deepPocketsRange = this.getAvailableDeepPocketsRange();
        if (this.moveItemStackTo(itemStackDynamic, mainInventoryRange.getFirst(), mainInventoryRange.getLast() + 1, false) || this.moveItemStackTo(itemStackDynamic, deepPocketsRange.getFirst(), deepPocketsRange.getLast() + 1, false)) {
            if (this.inventoryAddon.getPlayer().level().isClientSide) {
                InventorioNetworking.Companion.getInstance().c2sMoveItemToUtilityBelt(sourceSlot.index);
            }
            return true;
        }
        return false;
    }

    public final void updateDeepPocketsCapacity() {
        DeepPocketsSlot slot;
        int n;
        Player player = this.inventoryAddon.getPlayer();
        IntRange intRange = this.getAvailableDeepPocketsRange();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.getSlot(i), (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                ((DeepPocketsSlot)this.getSlot(i)).canTakeItems = true;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getAvailableUtilityBeltRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.getSlot(i), (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                ((DeepPocketsSlot)this.getSlot(i)).canTakeItems = true;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getUnavailableDeepPocketsRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Slot slot2 = this.getSlot(i);
                Intrinsics.checkNotNull((Object)slot2, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                slot = (DeepPocketsSlot)slot2;
                player.drop(slot.getItem(), false, true);
                slot.setByPlayer(ItemStack.EMPTY);
                slot.canTakeItems = false;
                if (i == n) break;
                ++i;
            }
        }
        if ((i = (intRange = this.getUnavailableUtilityBeltRange()).getFirst()) <= (n = intRange.getLast())) {
            while (true) {
                Slot slot3 = this.getSlot(i);
                Intrinsics.checkNotNull((Object)slot3, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.slot.DeepPocketsSlot");
                slot = (DeepPocketsSlot)slot3;
                player.drop(slot.getItem(), false, true);
                slot.setByPlayer(ItemStack.EMPTY);
                slot.canTakeItems = false;
                if (this.inventoryAddon.getSelectedUtility() >= 4) {
                    PlayerInventoryAddon playerInventoryAddon = this.inventoryAddon;
                    playerInventoryAddon.setSelectedUtility(playerInventoryAddon.getSelectedUtility() - 4);
                }
                if (i == n) break;
                ++i;
            }
        }
        if (this.inventoryAddon.getPlayer().level().isClientSide) {
            this.refreshSlotPositions();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private final void refreshSlotPositions() {
        SlotAccessor slot;
        int relativeIndex;
        int absoluteIndex;
        IntProgressionIndices intProgressionIndices;
        Object object = Minecraft.getInstance().screen;
        InventorioScreen inventorioScreen = object instanceof InventorioScreen ? (InventorioScreen)((Object)object) : null;
        if (inventorioScreen != null) {
            inventorioScreen.onRefresh();
        }
        int deepPocketsRowCount = this.inventoryAddon.getDeepPocketsRowCount();
        object = RangeIteratorKt.withRelativeIndex((IntProgression)mainInventoryWithoutHotbarRange);
        while (((Iterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot2 = this.getSlot(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot2, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot2;
            slot.setX(UIConstants.SLOTS_INVENTORY_MAIN((int)deepPocketsRowCount).x + 18 * (relativeIndex % 9));
            slot.setY(UIConstants.SLOTS_INVENTORY_MAIN((int)deepPocketsRowCount).y + 18 * (relativeIndex / 9));
        }
        object = RangeIteratorKt.withRelativeIndex((IntProgression)hotbarRange);
        while (((Iterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot3 = this.getSlot(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot3, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot3;
            slot.setX(UIConstants.SLOTS_INVENTORY_HOTBAR((int)deepPocketsRowCount).x + 18 * relativeIndex);
            slot.setY(UIConstants.SLOTS_INVENTORY_HOTBAR((int)deepPocketsRowCount).y);
        }
        object = RangeIteratorKt.withRelativeIndex((IntProgression)toolBeltRange);
        while (((Iterator)object).hasNext()) {
            intProgressionIndices = ((IntProgressionIterator)object).next();
            absoluteIndex = intProgressionIndices.component1();
            relativeIndex = intProgressionIndices.component2();
            Slot slot4 = this.getSlot(absoluteIndex);
            Intrinsics.checkNotNull((Object)slot4, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.accessor.SlotAccessor");
            slot = (SlotAccessor)slot4;
            slot.setX(ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).x);
            slot.setY(ToolBeltSlot.Companion.getSlotPosition((int)deepPocketsRowCount, (int)relativeIndex, (int)this.getToolBeltSlotCount()).y);
        }
    }

    private final IntRange getAvailableUtilityBeltRange() {
        return RangeIteratorKt.expandBy(utilityBeltRange.getFirst(), this.inventoryAddon.getAvailableUtilityBeltSize());
    }

    private final IntRange getUnavailableUtilityBeltRange() {
        return new IntRange(this.getAvailableUtilityBeltRange().getLast() + 1, utilityBeltRange.getLast());
    }

    @NotNull
    public final IntRange getAvailableDeepPocketsRange() {
        return RangeIteratorKt.expandBy(deepPocketsRange.getFirst(), this.inventoryAddon.getDeepPocketsRowCount() * 9);
    }

    private final IntRange getUnavailableDeepPocketsRange() {
        return new IntRange(this.getAvailableDeepPocketsRange().getLast() + 1, deepPocketsRange.getLast());
    }

    public final int getToolBeltSlotCount() {
        return PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio_mc1_21_1_neoforge().size();
    }

    public boolean shouldMoveToInventory(int index) {
        return index != this.getResultSlotIndex();
    }

    public void fillCraftSlotsStackedContents(@NotNull StackedContents finder) {
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        this.craftingInput.fillStackedContents(finder);
    }

    public void clearCraftingContent() {
        this.craftingResult.clearContent();
        this.craftingInput.clearContent();
    }

    public boolean recipeMatches(@Nullable RecipeHolder<CraftingRecipe> recipe) {
        CraftingRecipe craftingRecipe = recipe;
        return craftingRecipe != null && (craftingRecipe = (CraftingRecipe)craftingRecipe.value()) != null ? craftingRecipe.matches((RecipeInput)this.craftingInput.asCraftInput(), this.inventory.player.level()) : false;
    }

    public void slotsChanged(@NotNull Container inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        CraftingScreenHandlerAccessor.updateTheResult((AbstractContainerMenu)this, this.inventory.player.level(), this.inventory.player, (CraftingContainer)this.craftingInput, this.craftingResult, null);
    }

    public void removed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.removed(player);
        this.craftingResult.clearContent();
        if (!player.level().isClientSide) {
            this.clearContainer(player, (Container)this.craftingInput);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slot) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return slot.container != this.craftingResult && super.canTakeItemForPickAll(stack, slot);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftingInput.getWidth();
    }

    public int getGridHeight() {
        return this.craftingInput.getHeight();
    }

    public int getSize() {
        return 5;
    }

    @NotNull
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @NotNull
    public Slot getSlot(int index) {
        NonNullList nonNullList = this.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        Slot slot = super.getSlot(RangesKt.coerceIn((int)index, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)((Collection)nonNullList)))));
        Intrinsics.checkNotNullExpressionValue((Object)slot, (String)"getSlot(...)");
        return slot;
    }

    public void setItem(int slot, int revision, @Nullable ItemStack stack) {
        super.setItem(slot, revision, stack);
    }

    @Nullable
    public static final InventorioScreenHandler getInventorioScreenHandler(@NotNull Player $this$getInventorioScreenHandler) {
        return Companion.getInventorioScreenHandler($this$getInventorioScreenHandler);
    }

    @JvmStatic
    public static final void registerOpenConsumer(@NotNull ResourceLocation customIdentifier, @NotNull Consumer<InventorioScreenHandler> screenHandlerConsumer) {
        Companion.registerOpenConsumer(customIdentifier, screenHandlerConsumer);
    }

    @JvmStatic
    public static final void open(@NotNull Player player) {
        Companion.open(player);
    }

    static {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        armorSlots = equipmentSlotArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0012R \u0010\u001d\u001a\u0004\u0018\u00010\u0007*\u00020\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lde/rubixdev/inventorio/player/InventorioScreenHandler$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "customIdentifier", "Ljava/util/function/Consumer;", "Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "screenHandlerConsumer", "", "registerOpenConsumer", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/function/Consumer;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "open", "(Lnet/minecraft/world/entity/player/Player;)V", "Lkotlin/ranges/IntRange;", "craftingGridRange", "Lkotlin/ranges/IntRange;", "armorSlotsRange", "mainInventoryRange", "deepPocketsRange", "utilityBeltRange", "toolBeltRange", "mainInventoryWithoutHotbarRange", "hotbarRange", "getInventorioScreenHandler", "(Lnet/minecraft/world/entity/player/Player;)Lde/rubixdev/inventorio/player/InventorioScreenHandler;", "getInventorioScreenHandler$annotations", "inventorioScreenHandler", "", "openConsumers", "Ljava/util/Map;", "", "Lnet/minecraft/world/entity/EquipmentSlot;", "armorSlots", "[Lnet/minecraft/world/entity/EquipmentSlot;", "inventorio-mc1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final InventorioScreenHandler getInventorioScreenHandler(@NotNull Player $this$inventorioScreenHandler) {
            Intrinsics.checkNotNullParameter((Object)$this$inventorioScreenHandler, (String)"<this>");
            AbstractContainerMenu abstractContainerMenu = $this$inventorioScreenHandler.containerMenu;
            return abstractContainerMenu instanceof InventorioScreenHandler ? (InventorioScreenHandler)abstractContainerMenu : null;
        }

        @JvmStatic
        public static /* synthetic */ void getInventorioScreenHandler$annotations(Player player) {
        }

        @JvmStatic
        public final void registerOpenConsumer(@NotNull ResourceLocation customIdentifier, @NotNull Consumer<InventorioScreenHandler> screenHandlerConsumer) {
            Intrinsics.checkNotNullParameter((Object)customIdentifier, (String)"customIdentifier");
            Intrinsics.checkNotNullParameter(screenHandlerConsumer, (String)"screenHandlerConsumer");
            if (openConsumers.containsKey(customIdentifier)) {
                throw new IllegalStateException("The Identifier '" + customIdentifier + "' has already been taken");
            }
            openConsumers.put(customIdentifier, screenHandlerConsumer);
        }

        @JvmStatic
        public final void open(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            player.openMenu((MenuProvider)new SimpleMenuProvider(Companion::open$lambda$0, (Component)Component.translatable((String)"container.crafting")));
        }

        private static final AbstractContainerMenu open$lambda$0(int syncId, Inventory playerInventory, Player player) {
            Inventory inventory = playerInventory;
            Intrinsics.checkNotNull((Object)inventory);
            return (AbstractContainerMenu)new InventorioScreenHandler(syncId, inventory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

