/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player;

import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\fJ5\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lde/rubixdev/inventorio/player/PlayerAddonSerializer;", "", "<init>", "()V", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "inventoryAddon", "Lnet/minecraft/nbt/CompoundTag;", "inventorioTag", "", "serialize", "(Lnet/minecraft/core/HolderLookup$Provider;Lde/rubixdev/inventorio/player/PlayerInventoryAddon;Lnet/minecraft/nbt/CompoundTag;)V", "", "Lnet/minecraft/world/item/ItemStack;", "section", "Lnet/minecraft/nbt/ListTag;", "serializeSection", "(Lnet/minecraft/core/HolderLookup$Provider;Ljava/util/List;)Lnet/minecraft/nbt/ListTag;", "deserialize", "", "inventorySection", "sectionTag", "deserializeSection", "(Lnet/minecraft/core/HolderLookup$Provider;Lde/rubixdev/inventorio/player/PlayerInventoryAddon;Ljava/util/List;Lnet/minecraft/nbt/ListTag;)V", "inventorio-mc1.21.1-neoforge"})
public final class PlayerAddonSerializer {
    @NotNull
    public static final PlayerAddonSerializer INSTANCE = new PlayerAddonSerializer();

    private PlayerAddonSerializer() {
    }

    public final void serialize(@NotNull HolderLookup.Provider registries, @NotNull PlayerInventoryAddon inventoryAddon, @NotNull CompoundTag inventorioTag) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)((Object)inventoryAddon), (String)"inventoryAddon");
        Intrinsics.checkNotNullParameter((Object)inventorioTag, (String)"inventorioTag");
        inventorioTag.putInt("SelectedUtilitySlot", inventoryAddon.getSelectedUtility());
        inventorioTag.put("DeepPockets", (Tag)this.serializeSection(registries, inventoryAddon.deepPockets));
        inventorioTag.put("UtilityBelt", (Tag)this.serializeSection(registries, inventoryAddon.utilityBelt));
        inventorioTag.put("ToolBelt", (Tag)this.serializeSection(registries, inventoryAddon.toolBelt));
    }

    private final ListTag serializeSection(HolderLookup.Provider registries, List<ItemStack> section) {
        ListTag resultTag = new ListTag();
        Iterator iterator = ((Iterable)section).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int slotIndex = n++;
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", slotIndex);
            Tag tag = itemStack.save(registries, (Tag)itemTag);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
            itemTag = (CompoundTag)tag;
            resultTag.add((Object)itemTag);
        }
        return resultTag;
    }

    public final void deserialize(@NotNull HolderLookup.Provider registries, @NotNull PlayerInventoryAddon inventoryAddon, @NotNull CompoundTag inventorioTag) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)((Object)inventoryAddon), (String)"inventoryAddon");
        Intrinsics.checkNotNullParameter((Object)inventorioTag, (String)"inventorioTag");
        inventoryAddon.setSelectedUtility(inventorioTag.getInt("SelectedUtilitySlot"));
        List list = inventoryAddon.utilityBelt;
        ListTag listTag = inventorioTag.getList("UtilityBelt", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        this.deserializeSection(registries, inventoryAddon, list, listTag);
        List list2 = inventoryAddon.toolBelt;
        ListTag listTag2 = inventorioTag.getList("ToolBelt", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag2, (String)"getList(...)");
        this.deserializeSection(registries, inventoryAddon, list2, listTag2);
        List list3 = inventoryAddon.deepPockets;
        ListTag listTag3 = inventorioTag.getList("DeepPockets", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag3, (String)"getList(...)");
        this.deserializeSection(registries, inventoryAddon, list3, listTag3);
    }

    private final void deserializeSection(HolderLookup.Provider registries, PlayerInventoryAddon inventoryAddon, List<ItemStack> inventorySection, ListTag sectionTag) {
        int n = ((Collection)inventorySection).size();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            inventorySection.set(i, itemStack);
        }
        Iterator iterator = sectionTag.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Tag itemTag = (Tag)iterator2.next();
            Intrinsics.checkNotNull((Object)itemTag, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
            CompoundTag compoundTag = (CompoundTag)itemTag;
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compoundTag);
            int slotIndex = compoundTag.getInt("Slot");
            boolean bl = 0 <= slotIndex ? slotIndex < ((Collection)inventorySection).size() : false;
            if (bl) {
                Intrinsics.checkNotNull((Object)itemStack);
                inventorySection.set(slotIndex, itemStack);
                continue;
            }
            inventoryAddon.getPlayer().drop(itemStack, false);
        }
    }
}

