/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player;

import com.google.common.collect.ImmutableList;
import de.rubixdev.inventorio.api.InventorioAddonSection;
import de.rubixdev.inventorio.api.InventorioTickHandler;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.config.GlobalSettings;
import de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtraStuff;
import de.rubixdev.inventorio.util.PlayerDuck;
import de.rubixdev.inventorio.util.RandomStuff;
import de.rubixdev.inventorio.util.ToolBeltMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001c\u001bB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJC\u0010\u0014\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\r\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff;", "Lnet/minecraft/world/entity/player/Player;", "player", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "", "tick", "()V", "", "Lnet/minecraft/resources/ResourceLocation;", "Lde/rubixdev/inventorio/api/InventorioTickHandler;", "tickHandler", "playerInventoryAddon", "Lde/rubixdev/inventorio/api/InventorioAddonSection;", "deepPockets", "Lnet/minecraft/world/item/ItemStack;", "item", "", "index", "tickMe", "(Ljava/util/Map$Entry;Lde/rubixdev/inventorio/player/PlayerInventoryAddon;Lde/rubixdev/inventorio/api/InventorioAddonSection;Lnet/minecraft/world/item/ItemStack;I)V", "stack", "syncItems", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V", "prevSelectedSlot", "I", "Companion", "Client", "inventorio-mc1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPlayerInventoryAddon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryAddon.kt\nde/rubixdev/inventorio/player/PlayerInventoryAddon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1863#2,2:144\n774#2:146\n865#2,2:147\n1863#2,2:149\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryAddon.kt\nde/rubixdev/inventorio/player/PlayerInventoryAddon\n*L\n45#1:144,2\n46#1:146\n46#1:147,2\n46#1:149,2\n*E\n"})
public final class PlayerInventoryAddon
extends PlayerInventoryExtraStuff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int prevSelectedSlot;
    @NotNull
    private static final Map<ResourceLocation, InventorioTickHandler> tickHandlers = new LinkedHashMap();
    @NotNull
    private static final List<ToolBeltSlotTemplate> toolBeltTemplates = new ArrayList();
    private static boolean bNoMoreToolBeltSlots;

    public PlayerInventoryAddon(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
        bNoMoreToolBeltSlots = true;
        this.prevSelectedSlot = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void tick() {
        void $this$filterTo$iv$iv;
        long ms = Util.getMillis();
        if (this.getPlayer().swinging) {
            this.setDisplayToolTimeStamp(ms + (long)1000);
        }
        if (this.getDisplayToolTimeStamp() <= ms || this.prevSelectedSlot != -1 && this.prevSelectedSlot != this.getPlayer().getInventory().selected) {
            this.setDisplayTool(ItemStack.EMPTY);
        }
        this.prevSelectedSlot = this.getPlayer().getInventory().selected;
        Iterable $this$forEach$iv = (Iterable)this.stacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Player player = this.getPlayer();
            Intrinsics.checkNotNull((Object)it);
            this.syncItems(player, it);
        }
        Iterable $this$filter$iv = (Iterable)this.stacks;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!RandomStuff.isNotEmpty(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            it.inventoryTick(this.getPlayer().level(), (Entity)this.getPlayer(), -2, false);
        }
        for (Map.Entry<ResourceLocation, InventorioTickHandler> tickHandler : tickHandlers.entrySet()) {
            ItemStack item;
            int index;
            iterator = ((Iterable)this.deepPockets).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index2 = n++;
                ItemStack item2 = (ItemStack)iterator.next();
                Intrinsics.checkNotNull((Object)item2);
                this.tickMe(tickHandler, this, InventorioAddonSection.DEEP_POCKETS, item2, index2);
            }
            iterator = ((Iterable)this.toolBelt).iterator();
            n = 0;
            while (iterator.hasNext()) {
                index = n++;
                item = (ItemStack)iterator.next();
                Intrinsics.checkNotNull((Object)item);
                this.tickMe(tickHandler, this, InventorioAddonSection.TOOLBELT, item, index);
            }
            iterator = ((Iterable)this.utilityBelt).iterator();
            n = 0;
            while (iterator.hasNext()) {
                index = n++;
                item = (ItemStack)iterator.next();
                Intrinsics.checkNotNull((Object)item);
                this.tickMe(tickHandler, this, InventorioAddonSection.UTILITY_BELT, item, index);
            }
        }
        if (!this.getPlayer().level().isClientSide) {
            this.sendUpdateS2C();
        }
    }

    private final void tickMe(Map.Entry<ResourceLocation, ? extends InventorioTickHandler> tickHandler, PlayerInventoryAddon playerInventoryAddon, InventorioAddonSection deepPockets, ItemStack item, int index) {
        try {
            tickHandler.getValue().tick(playerInventoryAddon, deepPockets, item, index);
        }
        catch (Throwable e) {
            RandomStuff.getLogger().error("Inventory Tick Handler '" + tickHandler.getKey() + "' has failed: ", e);
        }
    }

    private final void syncItems(Player player, ItemStack stack) {
        block1: {
            if (!stack.getItem().isComplex() || !(player instanceof ServerPlayer)) break block1;
            Item item = stack.getItem();
            ComplexItem complexItem = item instanceof ComplexItem ? (ComplexItem)item : null;
            if (complexItem != null && (complexItem = complexItem.getUpdatePacket(stack, ((ServerPlayer)player).level(), player)) != null) {
                ComplexItem packet = complexItem;
                boolean bl = false;
                ((ServerPlayer)player).connection.send((Packet)packet);
            }
        }
    }

    @Nullable
    public static final PlayerInventoryAddon getInventoryAddon(@NotNull Player $this$getInventoryAddon) {
        return Companion.getInventoryAddon($this$getInventoryAddon);
    }

    @JvmStatic
    public static final void registerTickHandler(@NotNull ResourceLocation customIdentifier, @NotNull InventorioTickHandler tickHandler) {
        Companion.registerTickHandler(customIdentifier, tickHandler);
    }

    @JvmStatic
    @Nullable
    public static final ToolBeltSlotTemplate registerToolBeltTemplateIfNotExists(@NotNull String slotName, @NotNull ToolBeltSlotTemplate template) {
        return Companion.registerToolBeltTemplateIfNotExists(slotName, template);
    }

    @JvmStatic
    @Nullable
    public static final ToolBeltSlotTemplate getToolBeltTemplate(@NotNull String slotName) {
        return Companion.getToolBeltTemplate(slotName);
    }

    @JvmStatic
    @NotNull
    public static final ImmutableList<ToolBeltSlotTemplate> getToolBeltTemplates() {
        return Companion.getToolBeltTemplates();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lde/rubixdev/inventorio/player/PlayerInventoryAddon$Client;", "", "<init>", "()V", "", "activateSelectedUtility", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "getLocal", "()Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "local", "", "selectedHotbarSection", "I", "", "triesToUseUtility", "Z", "isUsingUtility", "inventorio-mc1.21.1-neoforge"})
    public static final class Client {
        @NotNull
        public static final Client INSTANCE = new Client();
        @JvmField
        public static int selectedHotbarSection = -1;
        @JvmField
        public static boolean triesToUseUtility;
        @JvmField
        public static boolean isUsingUtility;

        private Client() {
        }

        @Nullable
        public final PlayerInventoryAddon getLocal() {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            return localPlayer != null ? Companion.getInventoryAddon((Player)localPlayer) : null;
        }

        public final void activateSelectedUtility() {
            triesToUseUtility = true;
            isUsingUtility = true;
            Minecraft minecraft = Minecraft.getInstance();
            Intrinsics.checkNotNull((Object)minecraft, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor");
            ((MinecraftClientAccessor)minecraft).invokeDoItemUse();
            triesToUseUtility = false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015R \u0010\u001c\u001a\u0004\u0018\u00010\u0017*\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010!\u001a\b\u0012\u0004\u0012\u00020\r0 8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lde/rubixdev/inventorio/player/PlayerInventoryAddon$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "customIdentifier", "Lde/rubixdev/inventorio/api/InventorioTickHandler;", "tickHandler", "", "registerTickHandler", "(Lnet/minecraft/resources/ResourceLocation;Lde/rubixdev/inventorio/api/InventorioTickHandler;)V", "", "slotName", "Lde/rubixdev/inventorio/api/ToolBeltSlotTemplate;", "template", "registerToolBeltTemplateIfNotExists", "(Ljava/lang/String;Lde/rubixdev/inventorio/api/ToolBeltSlotTemplate;)Lde/rubixdev/inventorio/api/ToolBeltSlotTemplate;", "getToolBeltTemplate", "(Ljava/lang/String;)Lde/rubixdev/inventorio/api/ToolBeltSlotTemplate;", "Lcom/google/common/collect/ImmutableList;", "getToolBeltTemplates", "()Lcom/google/common/collect/ImmutableList;", "Lnet/minecraft/world/entity/player/Player;", "Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "getInventoryAddon", "(Lnet/minecraft/world/entity/player/Player;)Lde/rubixdev/inventorio/player/PlayerInventoryAddon;", "getInventoryAddon$annotations", "(Lnet/minecraft/world/entity/player/Player;)V", "inventoryAddon", "", "tickHandlers", "Ljava/util/Map;", "", "toolBeltTemplates", "Ljava/util/List;", "getToolBeltTemplates$inventorio_mc1_21_1_neoforge", "()Ljava/util/List;", "", "bNoMoreToolBeltSlots", "Z", "inventorio-mc1.21.1-neoforge"})
    @SourceDebugExtension(value={"SMAP\nPlayerInventoryAddon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryAddon.kt\nde/rubixdev/inventorio/player/PlayerInventoryAddon$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n295#2,2:144\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryAddon.kt\nde/rubixdev/inventorio/player/PlayerInventoryAddon$Companion\n*L\n134#1:144,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PlayerInventoryAddon getInventoryAddon(@NotNull Player $this$inventoryAddon) {
            Intrinsics.checkNotNullParameter((Object)$this$inventoryAddon, (String)"<this>");
            return ((PlayerDuck)$this$inventoryAddon).inventorio$getInventorioAddon();
        }

        @JvmStatic
        public static /* synthetic */ void getInventoryAddon$annotations(Player player) {
        }

        @NotNull
        public final List<ToolBeltSlotTemplate> getToolBeltTemplates$inventorio_mc1_21_1_neoforge() {
            return toolBeltTemplates;
        }

        @JvmStatic
        public final void registerTickHandler(@NotNull ResourceLocation customIdentifier, @NotNull InventorioTickHandler tickHandler) {
            Intrinsics.checkNotNullParameter((Object)customIdentifier, (String)"customIdentifier");
            Intrinsics.checkNotNullParameter((Object)tickHandler, (String)"tickHandler");
            if (tickHandlers.containsKey(customIdentifier)) {
                throw new IllegalStateException("The Identifier '" + customIdentifier + "' has already been taken");
            }
            tickHandlers.put(customIdentifier, tickHandler);
        }

        @JvmStatic
        @Nullable
        public final ToolBeltSlotTemplate registerToolBeltTemplateIfNotExists(@NotNull String slotName, @NotNull ToolBeltSlotTemplate template) {
            Intrinsics.checkNotNullParameter((Object)slotName, (String)"slotName");
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            if (GlobalSettings.toolBeltMode.getValue() == ToolBeltMode.DISABLED) {
                return null;
            }
            if (bNoMoreToolBeltSlots) {
                throw new IllegalStateException("You can't add any more ToolBelt Slots after a player has already been spawned! Please move the creation of extra ToolBelt Slots earlier.");
            }
            ToolBeltSlotTemplate existing = this.getToolBeltTemplate(slotName);
            if (existing != null) {
                return existing;
            }
            this.getToolBeltTemplates$inventorio_mc1_21_1_neoforge().add(template);
            return template;
        }

        @JvmStatic
        @Nullable
        public final ToolBeltSlotTemplate getToolBeltTemplate(@NotNull String slotName) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)slotName, (String)"slotName");
                Iterable $this$firstOrNull$iv = this.getToolBeltTemplates$inventorio_mc1_21_1_neoforge();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ToolBeltSlotTemplate it = (ToolBeltSlotTemplate)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)slotName)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @JvmStatic
        @NotNull
        public final ImmutableList<ToolBeltSlotTemplate> getToolBeltTemplates() {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.getToolBeltTemplates$inventorio_mc1_21_1_neoforge());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return immutableList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

