/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.player.inventory;

import de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor;
import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryHandFeatures;
import de.rubixdev.inventorio.util.RandomStuff;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff;", "Lde/rubixdev/inventorio/player/inventory/PlayerInventoryHandFeatures;", "Lnet/minecraft/world/entity/player/Player;", "player", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "block", "", "getMiningSpeedMultiplier", "(Lnet/minecraft/world/level/block/state/BlockState;)F", "Lnet/minecraft/world/item/ItemStack;", "getMostPreferredTool", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "", "playerAttackConditions", "()Z", "", "prePlayerAttack", "()V", "postPlayerAttack", "fireRocketFromInventory", "itemStack", "tryFireRocket", "(Lnet/minecraft/world/item/ItemStack;)Z", "inventorio-mc1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPlayerInventoryExtraStuff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInventoryExtraStuff.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n12574#2,2:136\n12574#2,2:154\n1971#3,14:138\n295#3,2:152\n*S KotlinDebug\n*F\n+ 1 PlayerInventoryExtraStuff.kt\nde/rubixdev/inventorio/player/inventory/PlayerInventoryExtraStuff\n*L\n33#1:136,2\n69#1:154,2\n47#1:138,14\n58#1:152,2\n*E\n"})
public abstract class PlayerInventoryExtraStuff
extends PlayerInventoryHandFeatures {
    protected PlayerInventoryExtraStuff(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(player);
    }

    public final float getMiningSpeedMultiplier(@NotNull BlockState block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ItemStack tool = this.getMostPreferredTool(block);
        if (!Intrinsics.areEqual((Object)tool, (Object)this.getActualMainHandItem())) {
            boolean bl;
            block3: {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                Object[] $this$any$iv = stackTraceElementArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"snownee.jade.addon", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) {
                this.setDisplayTool(tool);
            }
        }
        return Math.max(1.0f, tool.getDestroySpeed(block));
    }

    private final ItemStack getMostPreferredTool(BlockState block) {
        boolean isGlass;
        ItemStack result;
        ItemStack itemStack;
        Object v0;
        if (this.getActualMainHandItem().getItem() instanceof TieredItem || this.findFittingToolBeltIndex(this.getActualMainHandItem()) != -1) {
            return this.getActualMainHandItem();
        }
        Iterable $this$maxByOrNull$iv = this.toolBelt;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ItemStack it = (ItemStack)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getDestroySpeed(block);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemStack it2 = (ItemStack)e$iv;
                    $i$a$-maxByOrNull-PlayerInventoryExtraStuff$getMostPreferredTool$result$1 = false;
                    float v$iv = it2.getDestroySpeed(block);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((itemStack = (ItemStack)v0) == null) {
            itemStack = ItemStack.EMPTY;
        }
        if ((result = itemStack).getDestroySpeed(block) > 1.0f) {
            Intrinsics.checkNotNull((Object)result);
            return result;
        }
        boolean bl = isGlass = block.getBlock() instanceof StainedGlassBlock || block.is(Blocks.GLASS);
        if (isGlass) {
            ItemStack itemStack2;
            Object v6;
            block11: {
                Entity entity = (Entity)this.getPlayer();
                ResourceKey resourceKey = Enchantments.SILK_TOUCH;
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"SILK_TOUCH");
                Holder.Reference<Enchantment> silkTouch = RandomStuff.getEnchantment(entity, (ResourceKey<Enchantment>)resourceKey);
                Iterable $this$firstOrNull$iv = this.toolBelt;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    Holder holder = (Holder)silkTouch;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(RandomStuff.getLevelOn((Holder<Enchantment>)holder, it) > 0)) continue;
                    v6 = element$iv;
                    break block11;
                }
                v6 = null;
            }
            if ((itemStack2 = (ItemStack)v6) == null) {
                ItemStack itemStack3 = ItemStack.EMPTY;
                itemStack2 = itemStack3;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
            }
            return itemStack2;
        }
        ItemStack itemStack4 = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"EMPTY");
        return itemStack4;
    }

    private final boolean playerAttackConditions() {
        boolean bl;
        block2: {
            if (this.getActualMainHandItem().getItem() instanceof TieredItem || this.findFittingToolBeltIndex(this.getActualMainHandItem()) != -1) {
                return false;
            }
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                StackTraceElement it = (StackTraceElement)element$iv;
                boolean bl2 = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"org.violetmoon.quark.content.tools.entity.rang", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return !bl;
    }

    public final void prePlayerAttack() {
        if (!this.playerAttackConditions()) {
            return;
        }
        this.getPlayer().swinging = true;
        ItemStack swordStack = this.findFittingToolBeltStack(new ItemStack((ItemLike)Items.DIAMOND_SWORD));
        this.setDisplayTool(!swordStack.isEmpty() ? swordStack : this.findFittingToolBeltStack(new ItemStack((ItemLike)Items.DIAMOND_AXE)));
        this.getDisplayTool().forEachModifier(EquipmentSlot.MAINHAND, (arg_0, arg_1) -> PlayerInventoryExtraStuff.prePlayerAttack$lambda$4(this, arg_0, arg_1));
    }

    public final void postPlayerAttack() {
        if (!this.playerAttackConditions()) {
            return;
        }
        this.getDisplayTool().forEachModifier(EquipmentSlot.MAINHAND, (arg_0, arg_1) -> PlayerInventoryExtraStuff.postPlayerAttack$lambda$5(this, arg_0, arg_1));
    }

    public final void fireRocketFromInventory() {
        ItemStack itemStack;
        if (!this.getPlayer().isFallFlying()) {
            return;
        }
        Iterator iterator = this.getPlayer().getInventory().items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            itemStack = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)itemStack);
            if (!this.tryFireRocket(itemStack)) continue;
            return;
        }
        Iterator iterator3 = this.stacks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            itemStack = (ItemStack)iterator2.next();
            Intrinsics.checkNotNull((Object)itemStack);
            if (!this.tryFireRocket(itemStack)) continue;
            return;
        }
    }

    private final boolean tryFireRocket(ItemStack itemStack) {
        if (itemStack.getItem() instanceof FireworkRocketItem) {
            Object object = (Fireworks)itemStack.getComponents().get(DataComponents.FIREWORKS);
            if (!(object != null && (object = object.explosions()) != null ? !object.isEmpty() : false)) {
                ItemStack copyStack = itemStack.copy();
                if (!this.getPlayer().getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                if (this.getPlayer().level().isClientSide) {
                    this.setDisplayTool(itemStack);
                    InventorioNetworking.Companion.getInstance().c2sUseBoostRocket();
                    Minecraft minecraft = Minecraft.getInstance();
                    Intrinsics.checkNotNull((Object)minecraft, (String)"null cannot be cast to non-null type de.rubixdev.inventorio.mixin.client.accessor.MinecraftClientAccessor");
                    ((MinecraftClientAccessor)minecraft).setItemUseCooldown(4);
                } else {
                    this.getPlayer().level().addFreshEntity((Entity)new FireworkRocketEntity(this.getPlayer().level(), copyStack, (LivingEntity)this.getPlayer()));
                }
                return true;
            }
        }
        return false;
    }

    private static final void prePlayerAttack$lambda$4(PlayerInventoryExtraStuff this$0, Holder attribute, AttributeModifier modifier) {
        block1: {
            AttributeInstance instance;
            AttributeInstance attributeInstance = instance = this$0.getPlayer().getAttributes().getInstance(attribute);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(modifier);
            }
            AttributeInstance attributeInstance2 = instance;
            if (attributeInstance2 == null) break block1;
            attributeInstance2.addTransientModifier(modifier);
        }
    }

    private static final void postPlayerAttack$lambda$5(PlayerInventoryExtraStuff this$0, Holder attribute, AttributeModifier modifier) {
        block0: {
            AttributeInstance instance;
            AttributeInstance attributeInstance = instance = this$0.getPlayer().getAttributes().getInstance(attribute);
            if (attributeInstance == null) break block0;
            attributeInstance.removeModifier(modifier);
        }
    }
}

