/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.slot;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0012\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\"\u00a8\u0006$"}, d2={"Lde/rubixdev/inventorio/slot/ArmorSlot;", "Lnet/minecraft/world/inventory/Slot;", "Lnet/minecraft/world/Container;", "inventory", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/entity/EquipmentSlot;", "equipmentSlot", "", "index", "x", "y", "<init>", "(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;III)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "previousStack", "", "setStack", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V", "getMaxItemCount", "()I", "", "canInsert", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/entity/player/Player;", "playerEntity", "canTakeItems", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "getBackgroundSprite", "()Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/entity/EquipmentSlot;", "Companion", "inventorio-mc1.21.1-neoforge"})
public final class ArmorSlot
extends Slot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LivingEntity entity;
    @NotNull
    private final EquipmentSlot equipmentSlot;
    @NotNull
    private static final Map<EquipmentSlot, ResourceLocation> EMPTY_ARMOR_SLOT_TEXTURES;

    public ArmorSlot(@NotNull Container inventory, @NotNull LivingEntity entity, @NotNull EquipmentSlot equipmentSlot, int index, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
        super(inventory, index, x, y);
        this.entity = entity;
        this.equipmentSlot = equipmentSlot;
    }

    public void setByPlayer(@Nullable ItemStack stack, @Nullable ItemStack previousStack) {
        this.entity.onEquipItem(this.equipmentSlot, previousStack, stack);
        super.setByPlayer(stack, previousStack);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.equipmentSlot == this.entity.getEquipmentSlotForItem(stack);
    }

    public boolean mayPickup(@NotNull Player playerEntity) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        ItemStack itemStack = this.getItem();
        return (itemStack.isEmpty() || playerEntity.isCreative() || !EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(playerEntity);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_TEXTURES.get(this.equipmentSlot));
    }

    static {
        kotlin.Pair[] pairArray = new kotlin.Pair[]{TuplesKt.to((Object)EquipmentSlot.FEET, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS), TuplesKt.to((Object)EquipmentSlot.LEGS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS), TuplesKt.to((Object)EquipmentSlot.CHEST, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE), TuplesKt.to((Object)EquipmentSlot.HEAD, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET)};
        EMPTY_ARMOR_SLOT_TEXTURES = MapsKt.mapOf((kotlin.Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R(\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lde/rubixdev/inventorio/slot/ArmorSlot$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/world/entity/EquipmentSlot;", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "EMPTY_ARMOR_SLOT_TEXTURES", "Ljava/util/Map;", "inventorio-mc1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

