package de.rubixdev.inventorio.mixin;

import de.rubixdev.inventorio.packet.InventorioNetworking;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

//#if MC >= 12101
//$$ import net.minecraft.entity.Entity;
//#endif

@Mixin(class_3324.class)
public class PlayerManagerMixin {
    /**
     * This injection sends the last utility slot, saved by the server, from the
     * server to the client
     */
    @Inject(method = "onPlayerConnect", at = @At(value = "RETURN"), require = 0)
    private void inventorioSetPlayerSettings(
        class_2535 connection,
        class_3222 player,
        class_8792 clientData,
        CallbackInfo ci
    ) {
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(player);
        InventorioNetworking.getInstance().s2cGlobalSettings(player);
    }

    /**
     * This inject sends the last utility slot, saved by the server, from the
     * server to the client
     */
    @Inject(method = "respawnPlayer", at = @At(value = "RETURN"), require = 0)
    private void inventorioSetPlayerSettings(/* #if <- hack around formatter */
        class_3222 oldPlayer,
        boolean alive,
        //#if MC >= 12101
        //$$ Entity.RemovalReason removalReason,
        //#endif
        CallbackInfoReturnable<class_3222> cir
    ) {
        class_3222 newPlayer = cir.getReturnValue();
        MixinHelpers.withInventoryAddon(newPlayer, newAddon -> MixinHelpers.withInventoryAddon(oldPlayer, oldAddon -> {
            newAddon.setSwappedHands(oldAddon.getSwappedHands());
            newAddon.setSelectedUtility(oldAddon.getSelectedUtility());
        }));
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(newPlayer);
    }

    @Inject(method = "sendPlayerStatus", at = @At("RETURN"))
    private void sendSelectedUtility(class_3222 player, CallbackInfo ci) {
        InventorioNetworking.getInstance().s2cSelectUtilitySlot(player);
    }
}
