package de.rubixdev.inventorio.mixin;

import de.rubixdev.inventorio.util.MixinHelpers;
import net.minecraft.class_1268;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public class ServerPlayNetworkHandlerMixin {
    @Shadow
    public class_3222 player;

    /**
     * These two injections remove the display tool (server-side) when a player
     * tries to use (right-click) something from the main hand, so that the item
     * that's ACTUALLY in the main hand can be used immediately
     */
    @Inject(method = "onPlayerInteractBlock", at = @At(value = "HEAD"))
    private void inventorioRemoveDisplayHand(class_2885 packet, CallbackInfo ci) {
        if (packet.method_12546() == class_1268.field_5808)
            MixinHelpers.withInventoryAddon(player, addon -> addon.setDisplayTool(ItemStack.EMPTY));
    }

    @Inject(method = "onPlayerInteractItem", at = @At(value = "HEAD"))
    private void inventorioRemoveDisplayHand(class_2886 packet, CallbackInfo ci) {
        if (packet.method_12551() == class_1268.field_5808)
            MixinHelpers.withInventoryAddon(player, addon -> addon.setDisplayTool(ItemStack.EMPTY));
    }
}
