package de.rubixdev.inventorio.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value = class_465.class)
@Environment(EnvType.CLIENT)
public class HandledScreenMixin {
    @Shadow
    @Nullable protected class_1735 focusedSlot;

    /**
     * This injection allows to use the vanilla Swap Offhand key (F by default)
     * to move items to the Utility Belt in the inventory (the injected method
     * is an edge-case handler when you have "swap offhand" on mouse buttons)
     */
    @WrapOperation(
        method = "onMouseClick(I)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V",
            ordinal = 0
        ),
        slice = @Slice(
            from = @At(
                value = "FIELD",
                target = "Lnet/minecraft/client/option/GameOptions;swapHandsKey:Lnet/minecraft/client/option/KeyBinding;"
            )
        )
    )
    private void inventorioOffhandSwapWithMouse(
        class_465<?> instance,
        class_1735 slot,
        int slotId,
        int button,
        class_1713 actionType,
        Operation<Void> original
    ) {
        MixinHelpers.withScreenHandler(
            class_310.method_1551().field_1724,
            screenHandler -> screenHandler.tryTransferToUtilityBeltSlot(focusedSlot),
            player -> original.call(instance, slot, slotId, button, actionType, original)
        );
    }

    /**
     * This injection allows to use the vanilla Swap Offhand key (F by default)
     * to move items to the Utility Belt in the inventory
     */
    @WrapOperation(
        method = "handleHotbarKeyPressed",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V",
            ordinal = 0
        ),
        slice = @Slice(
            from = @At(
                value = "FIELD",
                target = "Lnet/minecraft/client/option/GameOptions;swapHandsKey:Lnet/minecraft/client/option/KeyBinding;"
            )
        )
    )
    private void inventorioOffhandSwapWithKeyboard(
        class_465<?> instance,
        class_1735 slot,
        int slotId,
        int button,
        class_1713 actionType,
        Operation<Void> original
    ) {
        MixinHelpers.withScreenHandler(
            class_310.method_1551().field_1724,
            screenHandler -> screenHandler.tryTransferToUtilityBeltSlot(focusedSlot),
            player -> original.call(instance, slot, slotId, button, actionType)
        );
    }
}
