package de.rubixdev.inventorio.mixin.client;

import de.rubixdev.inventorio.client.ui.HotbarHUDRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

//#if MC >= 12101
//$$ import net.minecraft.client.render.RenderTickCounter;
//#endif

@Mixin(value = class_329.class, priority = 1500)
@Environment(EnvType.CLIENT)
public class InGameHudMixinHP {
    /**
     * This mixin calls the renderer of hotbar addons. Note: this mixin doesn't
     * work in NeoForge and is substituted with a NeoForge event.
     */
    @Inject(method = "render", at = @At(value = "RETURN"))
    private void inventorioRenderHotbarAddons(/* #if <- hack around formatter */
        class_332 context,
        //#if MC >= 12101
        //$$ RenderTickCounter tickCounter,
        //#else
        float tickDelta,
        //#endif
        CallbackInfo ci
    ) {
        HotbarHUDRenderer.INSTANCE.renderHotbarAddons(context);
    }

    /**
     * This mixin removes the vanilla offhand display (both the item frame and
     * the item)
     */
    @Redirect(
        method = "renderHotbar",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/player/PlayerEntity;getOffHandStack()Lnet/minecraft/item/ItemStack;"
        )
    )
    private class_1799 inventorioRemoveOffhandDisplayFromHotbar(class_1657 playerEntity) {
        return class_1799.field_8037;
    }
}
