package de.rubixdev.inventorio.mixin.fabric.trinkets;

import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.util.TrinketsTester;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.api.SlotGroup;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_485;
import net.minecraft.class_518;
import net.minecraft.class_768;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("UnresolvedMixinReference") // the Minecraft Dev plugin
                                              // doesn't seem to like Kotlin
                                              // target classes
@Restriction(
    require = { @Condition("trinkets"), @Condition(type = Condition.Type.TESTER, tester = TrinketsTester.class) }
)
@Mixin(InventorioScreen.class)
public abstract class InventorioScreenMixin extends class_485<InventorioScreenHandler>
    implements class_518, TrinketScreen {
    public InventorioScreenMixin(InventorioScreenHandler screenHandler, class_1661 playerInventory, class_2561 text) {
        super(screenHandler, playerInventory, text);
    }

    @Inject(method = "init", at = @At("HEAD"))
    private void trinkets$init(CallbackInfo ci) {
        TrinketScreenManager.init(this);
    }

    @Inject(method = "handledScreenTick", at = @At("TAIL"))
    private void trinkets$tick(CallbackInfo ci) {
        TrinketScreenManager.tick();
    }

    @Inject(method = "render", at = @At("HEAD"))
    private void trinkets$render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        TrinketScreenManager.update(mouseX, mouseY);
    }

    @Inject(method = "drawBackground", at = @At("RETURN"))
    private void trinkets$drawBackground(class_332 context, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        TrinketScreenManager.drawExtraGroups(context);
    }

    @Inject(method = "drawForeground", at = @At("RETURN"))
    private void trinkets$drawForeground(class_332 context, int mouseX, int mouseY, CallbackInfo ci) {
        TrinketScreenManager.drawActiveGroup(context);
    }

    @Inject(method = "isClickOutsideBounds", at = @At("HEAD"), cancellable = true)
    private void trinkets$isClickOutsideBounds(
        double mouseX,
        double mouseY,
        int left,
        int top,
        int button,
        CallbackInfoReturnable<Boolean> cir
    ) {
        if (TrinketScreenManager.isClickInsideTrinketBounds(mouseX, mouseY)) {
            cir.setReturnValue(false);
        }
    }

    @Override
    public TrinketPlayerScreenHandler trinkets$getHandler() {
        // noinspection DataFlowIssue
        return (TrinketPlayerScreenHandler) (class_1703) field_2797;
    }

    @Override
    public class_768 trinkets$getGroupRect(SlotGroup group) {
        Point pos = trinkets$getHandler().trinkets$getGroupPos(group);
        if (pos != null) { return new class_768(pos.x() - 1, pos.y() - 1, 17, 17); }
        return new class_768(0, 0, 0, 0);
    }

    @Override
    public class_1735 trinkets$getFocusedSlot() {
        return field_2787;
    }

    @Override
    public int trinkets$getX() {
        return field_2776;
    }

    @Override
    public int trinkets$getY() {
        return field_2800;
    }
}
