package de.rubixdev.inventorio.mixin.optional.totem;

import de.rubixdev.inventorio.util.MixinHelpers;
import de.rubixdev.inventorio.util.TotemTester;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;

@Restriction(require = @Condition(type = Condition.Type.TESTER, tester = TotemTester.class))
@Mixin(value = class_1309.class, priority = 500)
public abstract class LivingEntityMixin extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    /**
     * This optional mixin allows a Totem of Undying to be used automatically
     * from any Utility Slot.
     */
    @SuppressWarnings("InvalidInjectorMethodSignature")
//    @ModifyVariable(
//            method = "tryUseTotem",
//            at = @At(value = "JUMP", ordinal = 2, shift = At.Shift.BEFORE),
//            slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;decrement(I)V")),
//            ordinal = 0
//    )
    @ModifyVariable(
        method = "tryUseTotem",
        at = @At(value = "JUMP", opcode = Opcodes.IFNULL, shift = At.Shift.BEFORE),
        slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;decrement(I)V")),
        ordinal = 0
    )
    private class_1799 inventorioGetTotemFromUtilityBar(class_1799 original) {
        // noinspection ConstantValue
        if (original != null || !((class_1297) this instanceof class_1657 player)) return original;
        return MixinHelpers.withInventoryAddonReturning(
            player,
            addon -> addon.utilityBelt.stream()
                .filter(stack -> stack.isOf(Items.TOTEM_OF_UNDYING))
                .findFirst()
                .map(totem -> {
                    ItemStack copy = totem.copy();
                    totem.decrement(1);
                    return copy;
                })
                .orElse(original)
        );
    }
}
