/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.api;

import com.google.common.collect.ImmutableList;
import de.rubixdev.inventorio.api.InventorioTickHandler;
import de.rubixdev.inventorio.api.OnInitKt;
import de.rubixdev.inventorio.api.ToolBeltSlotTemplate;
import de.rubixdev.inventorio.client.ui.InventorioScreen;
import de.rubixdev.inventorio.player.InventorioScreenHandler;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventorioAPI {
    public static final String SLOT_PICKAXE = "pickaxe";
    public static final String SLOT_SWORD = "sword";
    public static final String SLOT_AXE = "axe";
    public static final String SLOT_SHOVEL = "shovel";
    public static final String SLOT_HOE = "hoe";

    private InventorioAPI() {
    }

    public static void registerInventoryTickHandler(@NotNull class_2960 customIdentifier, @NotNull InventorioTickHandler tickHandler) {
        PlayerInventoryAddon.registerTickHandler(customIdentifier, tickHandler);
    }

    public static void registerScreenHandlerOpenConsumer(@NotNull class_2960 customIdentifier, Consumer<InventorioScreenHandler> screenHandlerConsumer) {
        InventorioScreenHandler.registerOpenConsumer(customIdentifier, screenHandlerConsumer);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerInventoryUIInitConsumer(@NotNull class_2960 customIdentifier, Consumer<InventorioScreen> uiConsumer) {
        InventorioScreen.registerInitConsumer(customIdentifier, uiConsumer);
    }

    @Nullable
    public static ToolBeltSlotTemplate registerToolBeltSlotIfNotExists(@NotNull String slotName, @NotNull class_2960 emptyIcon) {
        return PlayerInventoryAddon.registerToolBeltTemplateIfNotExists(slotName, new ToolBeltSlotTemplate(slotName, emptyIcon));
    }

    @Nullable
    public static ToolBeltSlotTemplate getToolBeltSlotTemplate(@NotNull String slotName) {
        return PlayerInventoryAddon.getToolBeltTemplate(slotName);
    }

    @NotNull
    public static class_1799 findFittingToolBeltStack(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull class_1799 sampleStack) {
        return playerInventoryAddon.findFittingToolBeltStack(sampleStack);
    }

    public static int findFittingToolBeltIndex(@NotNull PlayerInventoryAddon playerInventoryAddon, @NotNull class_1799 sampleStack) {
        return playerInventoryAddon.findFittingToolBeltIndex(sampleStack);
    }

    @NotNull
    public static ImmutableList<ToolBeltSlotTemplate> getToolBeltTemplates() {
        return PlayerInventoryAddon.getToolBeltTemplates();
    }

    @Nullable
    public static PlayerInventoryAddon getInventoryAddon(@NotNull class_1657 playerEntity) {
        return PlayerInventoryAddon.getInventoryAddon(playerEntity);
    }

    static {
        OnInitKt.onApiInit();
    }
}

