/*
 * Decompiled with CFR 0.152.
 */
package de.rubixdev.inventorio.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.rubixdev.inventorio.client.control.InventorioKeyHandler;
import de.rubixdev.inventorio.player.inventory.PlayerInventoryExtension;
import de.rubixdev.inventorio.util.MixinHelpers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1661.class}, priority=-5000)
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public class_1657 field_7546;

    @Inject(method={"method_7377(Lnet/minecraft/class_1661;)V"}, at={@At(value="RETURN")})
    private void inventorioClonePlayerInventory(class_1661 sourceInventory, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, thisAddon -> MixinHelpers.withInventoryAddon(sourceInventory.field_7546, thisAddon::cloneFrom));
    }

    @Inject(method={"method_7391()Lnet/minecraft/class_1799;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetMainHandStack(CallbackInfoReturnable<class_1799> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            class_1799 mainHandStack = inventorioAddon.getDisplayedMainHandStack();
            if (mainHandStack != null) {
                cir.setReturnValue((Object)mainHandStack);
            }
        });
    }

    @Inject(method={"method_7370(Lnet/minecraft/class_2680;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> cir.setReturnValue((Object)Float.valueOf(inventorioAddon.getMiningSpeedMultiplier(block))));
    }

    @Inject(method={"method_7367(ILnet/minecraft/class_1799;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioInsertSimilarStackIntoAddon(int slot, class_1799 originalStack, CallbackInfoReturnable<Boolean> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            if (slot == -1 && inventorioAddon != null && inventorioAddon.insertOnlySimilarStack(originalStack)) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @ModifyReturnValue(method={"method_7367(ILnet/minecraft/class_1799;)Z"}, at={@At(value="RETURN")})
    private boolean inventorioInsertStackIntoAddon(boolean original, int slot, class_1799 originalStack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.field_7546, addon -> slot == -1 && addon.insertStackIntoEmptySlot(originalStack)));
    }

    @Inject(method={"method_7378(Lnet/minecraft/class_1799;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioRemoveOneFromAddon(class_1799 stack, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            if (inventorioAddon != null && inventorioAddon.removeOne(stack)) {
                ci.cancel();
            }
        });
    }

    @Inject(method={"method_7388()V"}, at={@At(value="RETURN")})
    private void inventorioDropAllFromAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, PlayerInventoryExtension::dropAll);
    }

    @Inject(method={"method_5448()V"}, at={@At(value="RETURN")})
    private void inventorioClearAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, class_1277::method_5448);
    }

    @Inject(method={"method_7373(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void inventorioScrollInHotbar(double scrollAmount, CallbackInfo ci) {
        if (InventorioKeyHandler.INSTANCE.scrollInHotbar(this.field_7546, scrollAmount)) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"method_7379(Lnet/minecraft/class_1799;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, class_1799 stack) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.field_7546, addon -> addon.contains(stack)));
    }

    @ModifyReturnValue(method={"method_7382(Lnet/minecraft/class_6862;)Z"}, at={@At(value="RETURN")})
    private boolean searchAddon(boolean original, class_6862<class_1792> tag) {
        return original || Boolean.TRUE.equals(MixinHelpers.withInventoryAddonReturning(this.field_7546, addon -> addon.contains(tag)));
    }
}

