/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.commands;

import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.commands.AnimationArgument;
import com.finderfeed.fdlib.init.FDModEvents;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.TriggerAnimationReloadPacket;
import com.finderfeed.fdlib.systems.bedrock.TriggerModelReloadPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.packets.JsonConfigSyncPacket;
import com.finderfeed.fdlib.systems.config.packets.TriggerClientsideConfigReloadPacket;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fdlib", bus=EventBusSubscriber.Bus.GAME)
public class FDCommandsRegistry {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fdlib").then(((LiteralArgumentBuilder)Commands.literal((String)"animation_test").requires(stack -> stack.hasPermission(2))).then(Commands.argument((String)"animation", (ArgumentType)new AnimationArgument()).then(((RequiredArgumentBuilder)Commands.argument((String)"layer", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"entity").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> {
            FDCommandsRegistry.executeEntityAnimation((CommandContext<CommandSourceStack>)context, (String)context.getArgument("animation", String.class), (String)context.getArgument("layer", String.class), EntityArgument.getEntity((CommandContext)context, (String)"target"));
            return 1;
        })))).then(Commands.literal((String)"tile").then(Commands.argument((String)"target", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            FDCommandsRegistry.executeTileEntityAnimation((CommandContext<CommandSourceStack>)context, (String)context.getArgument("animation", String.class), (String)context.getArgument("layer", String.class), BlockPosArgument.getBlockPos((CommandContext)context, (String)"target"));
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").then(Commands.literal((String)"clientsideConfigs").executes(ctx -> {
            FDCommandsRegistry.reloadClientConfigs((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"configs").requires(stack -> stack.hasPermission(2))).executes(ctx -> {
            FDCommandsRegistry.reloadConfigs((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"models").requires(stack -> stack.hasPermission(2))).executes(ctx -> {
            FDCommandsRegistry.reloadModels((CommandContext<CommandSourceStack>)ctx);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"animations").requires(stack -> stack.hasPermission(2))).executes(ctx -> {
            FDCommandsRegistry.reloadAnimations((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })))).then(Commands.literal((String)"fix").then(Commands.literal((String)"cutscene").executes(stack -> {
            FDCommandsRegistry.emergencyCutsceneEnd((CommandContext<CommandSourceStack>)stack);
            return 1;
        }))));
    }

    public static void emergencyCutsceneEnd(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = stack.getPlayerOrException();
        FDLibCalls.stopCutsceneForPlayer(player);
    }

    public static void reloadAnimations(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            stack.sendSystemMessage((Component)Component.literal((String)"Reloading animations..."));
            FDModEvents.loadAnimations();
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TriggerAnimationReloadPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            stack.sendSystemMessage((Component)Component.literal((String)"Reload complete!"));
        } else {
            stack.sendFailure((Component)Component.literal((String)"Can only be used in dev environment."));
        }
    }

    public static void reloadModels(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            stack.sendSystemMessage((Component)Component.literal((String)"Reloading models..."));
            FDModEvents.loadModels();
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TriggerModelReloadPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            stack.sendSystemMessage((Component)Component.literal((String)"Reload complete!"));
        } else {
            stack.sendFailure((Component)Component.literal((String)"Can only be used in dev environment."));
        }
    }

    public static void reloadConfigs(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack stack = (CommandSourceStack)ctx.getSource();
        for (JsonConfig config : FDRegistries.CONFIGS) {
            if (config.isClientside()) continue;
            stack.sendSystemMessage((Component)Component.literal((String)("Loading config: " + String.valueOf(config.getName()))));
            config.loadFromDisk();
            stack.sendSystemMessage((Component)Component.literal((String)("Loaded config: " + String.valueOf(config.getName()))).withStyle(ChatFormatting.GREEN));
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new JsonConfigSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void reloadClientConfigs(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PacketDistributor.sendToPlayer((ServerPlayer)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CustomPacketPayload)new TriggerClientsideConfigReloadPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void executeEntityAnimation(CommandContext<CommandSourceStack> ctx, String animname, String tickerName, Entity entity) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)ctx.getSource();
        Animation animation = (Animation)FDRegistries.ANIMATIONS.get(ResourceLocation.parse((String)animname));
        if (animation == null) {
            sourceStack.sendFailure((Component)Component.literal((String)("No such animation found: " + animname)));
            return;
        }
        if (!(entity instanceof AnimatedObject)) {
            sourceStack.sendFailure((Component)Component.literal((String)"Entity is not an animatable object"));
            return;
        }
        AnimatedObject object = (AnimatedObject)entity;
        sourceStack.sendSystemMessage((Component)Component.literal((String)"Playing animation"));
        object.getSystem().startAnimation(tickerName, new AnimationTicker.Builder(animation).setLoopMode(Animation.LoopMode.ONCE).setToNullTransitionTime(0).build());
    }

    public static void executeTileEntityAnimation(CommandContext<CommandSourceStack> ctx, String animname, String tickerName, BlockPos pos) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)ctx.getSource();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        Animation animation = (Animation)FDRegistries.ANIMATIONS.get(ResourceLocation.parse((String)animname));
        if (animation == null) {
            sourceStack.sendFailure((Component)Component.literal((String)("No such animation found: " + animname)));
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AnimatedObject)) {
            sourceStack.sendFailure((Component)Component.literal((String)"Tile entity is not an animatable object"));
            return;
        }
        AnimatedObject object = (AnimatedObject)blockEntity;
        sourceStack.sendSystemMessage((Component)Component.literal((String)"Playing animation"));
        object.getSystem().startAnimation(tickerName, new AnimationTicker.Builder(animation).setLoopMode(Animation.LoopMode.ONCE).setToNullTransitionTime(0).build());
    }
}

