/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.data_structures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class IntRangedList<T>
implements Iterable<T> {
    private List<IntRangedListEntry<T>> entries = new ArrayList<IntRangedListEntry<T>>();

    public IntRangedList() {
    }

    public IntRangedList(IntRangedList<T> other) {
        this.entries.addAll(other.entries);
    }

    public IntRangedList(List<T> objects, boolean isSorted, Function<T, Integer> intExtractor) {
        if (isSorted) {
            for (T o : objects) {
                this.entries.add(new IntRangedListEntry<T>(intExtractor.apply(o), o));
            }
        } else {
            for (T o : objects) {
                this.add(intExtractor.apply(o), o, false);
            }
        }
    }

    public T getValue(int num) {
        return this.entries.get((int)this.indexOf((int)num)).value;
    }

    public int indexOf(int num) {
        if (this.entries.isEmpty()) {
            return -1;
        }
        if (this.entries.size() == 1) {
            return 0;
        }
        IntRangedListEntry<T> first = this.entries.getFirst();
        if (num <= first.num) {
            return 0;
        }
        IntRangedListEntry<T> last = this.entries.getLast();
        if (num >= last.num) {
            return this.entries.size() - 1;
        }
        for (int i = 1; i < this.entries.size(); ++i) {
            IntRangedListEntry<T> entry = this.entries.get(i);
            if (num >= entry.num) continue;
            return i - 1;
        }
        return -1;
    }

    public List<T> getValues(int number, int before, int after) {
        int id;
        ArrayList r = new ArrayList();
        for (int i = 0; i < before + after + 1; ++i) {
            r.add(null);
        }
        int entryIndex = this.indexOf(number);
        r.set(before, this.entries.get((int)entryIndex).value);
        int listIndex = before + 1;
        int t = 1;
        while (t <= after && (id = entryIndex + t) < this.entries.size()) {
            r.set(listIndex, this.entries.get((int)id).value);
            ++t;
            ++listIndex;
        }
        listIndex = 0;
        while (before > 0) {
            id = entryIndex - before;
            if (id >= 0) {
                r.set(listIndex, this.entries.get((int)id).value);
            }
            --before;
            ++listIndex;
        }
        return r;
    }

    public List<T> getAllValuesAfter(int number) {
        if (this.entries.isEmpty()) {
            return null;
        }
        int index = this.indexOf(number);
        ArrayList l = new ArrayList();
        IntRangedListEntry<T> value = this.entries.get(index);
        if (value.num >= number) {
            l.add(value.value);
        }
        for (int i = index + 1; i < this.entries.size(); ++i) {
            l.add(this.entries.get((int)i).value);
        }
        return l;
    }

    public void add(int num, T value, boolean replace) {
        int index = 0;
        for (IntRangedListEntry<T> entry : this.entries) {
            int n = entry.num;
            if (n > num) break;
            if (num == n) {
                if (!replace) {
                    throw new RuntimeException("Trying to add element with the same int value");
                }
                this.entries.set(index, new IntRangedListEntry<T>(num, value));
                return;
            }
            ++index;
        }
        this.entries.add(index, new IntRangedListEntry<T>(num, value));
    }

    public T get(int index) {
        return this.entries.get((int)index).value;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.entries.stream().map(IntRangedListEntry::value).iterator();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private record IntRangedListEntry<T>(int num, T value) {
    }
}

