/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.init.FDBlockEntities;
import com.finderfeed.fdlib.init.FDModels;
import com.finderfeed.fdlib.init.FDParticles;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityRendererBuilder;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockRenderLayerOptions;
import com.finderfeed.fdlib.systems.impact_frames.FDPostShadersReloadableResourceListener;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.FDTerrainParticle;
import com.finderfeed.fdlib.util.client.particles.InvisibleParticle;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticle;
import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticle;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.math.Axis;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="fdlib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FDClientModEvents {
    public static final String FDLIB_KEY_CATEGORY = "fdlib.key_category";
    public static final KeyMapping END_CUTSCENE = new KeyMapping("fdlib.key.end_cutscene", InputConstants.Type.KEYSYM, 74, "fdlib.key_category");

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(END_CUTSCENE);
    }

    @SubscribeEvent
    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new FDPostShadersReloadableResourceListener());
    }

    @SubscribeEvent
    public static void assignFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FDParticles.INVISIBLE.get(), InvisibleParticle.Factory::new);
        event.registerSpriteSet(FDParticles.BALL_PARTICLE.get(), BallParticle.Factory::new);
        event.registerSpecial(FDParticles.LIGHTNING_PARTICLE.get(), (ParticleProvider)new LightningParticle.Factory());
        event.registerSpecial(FDParticles.TERRAIN_PARTICLE.get(), (ParticleProvider)new FDTerrainParticle.Provider());
    }

    @SubscribeEvent
    public static void registerBERenderers(FMLClientSetupEvent event) {
        BlockEntityRenderers.register(FDBlockEntities.TEST.get(), FDBlockEntityRendererBuilder.builder().addLayer(FDBlockRenderLayerOptions.builder().model(FDModels.TEST).renderType((entity, pticks) -> {
            float t = entity.getLevel().getGameTime() % 10L;
            if (t < 5.0f) {
                return RenderType.eyes((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            }
            return RenderType.entityCutout((ResourceLocation)FDLib.location("textures/texture.png"));
        }).color((object, partialTicks) -> {
            Level l = object.getLevel();
            float t = ((float)l.getGameTime() + partialTicks) % 20.0f;
            return new FDColor(t / 20.0f, 1.0f, 1.0f, 1.0f);
        }).build()).addLayer(FDBlockRenderLayerOptions.builder().model(FDModels.TEST2).renderType(RenderType.eyes((ResourceLocation)FDLib.location("textures/texture.png"))).transformation((blockEntity, stack, partialTicks) -> {
            stack.mulPose(Axis.YP.rotationDegrees(90.0f));
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }).renderCondition(entity -> {
            if (entity.getLevel() == null) {
                return false;
            }
            return entity.getLevel().getGameTime() % 60L > 10L;
        }).build()).freeRender((blockEntity, pticks, matrices, src, light, overlay) -> {
            long gametime = Minecraft.getInstance().level.getGameTime();
            float time = ((float)gametime + pticks) / 10.0f;
            QuadRenderer.start(src.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"minecraft:textures/block/prismarine.png")))).pose(matrices).light(light).translate((float)Math.sin(time), 3.0f, (float)Math.cos(time)).direction(new Vec3(1.0, 1.0, 1.0)).rotationDegrees(time * 20.0f).offsetOnDirection((float)Math.sin(time) * 5.0f).setAnimated(Math.round(time) % 4, 4).render();
        }).build());
    }
}

