/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations;

import com.finderfeed.fdlib.data_structures.IntRangedList;
import com.finderfeed.fdlib.systems.bedrock.animations.AnimationContext;
import com.finderfeed.fdlib.systems.bedrock.animations.KeyFrame;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.List;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class AnimationUtil {
    public static Vector3f catmullRomThroughKeyFrames(AnimationContext context, IntRangedList<KeyFrame> keyFrames, float time, float partialTick) {
        List<KeyFrame> frames = keyFrames.getValues((int)Math.floor(time), 1, 2);
        KeyFrame current = frames.get(1);
        KeyFrame next = frames.get(2);
        if (next == null) {
            return current.getPostValue(context);
        }
        float localTime = time - (float)current.time;
        float timeBetween = next.time - current.time;
        float p = Mth.clamp((float)(localTime / timeBetween), (float)0.0f, (float)1.0f);
        KeyFrame f1 = frames.get(0);
        KeyFrame f4 = frames.get(3);
        return FDMathUtil.catmullrom(f1 != null ? f1.getPostValue(context) : null, current.getPostValue(context), next.getPostValue(context), f4 != null ? f4.getPostValue(context) : null, p);
    }
}

