/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system;

import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.AnimationContext;
import com.finderfeed.fdlib.systems.bedrock.animations.TransitionAnimation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AnimationSystem {
    private HashMap<String, AnimationTicker> tickers = new HashMap();
    private HashMap<String, Float> variables = new HashMap();
    private boolean isFrozen;

    public void tick() {
        if (this.isFrozen()) {
            return;
        }
        Iterator<Map.Entry<String, AnimationTicker>> entryIterator = this.tickers.entrySet().iterator();
        block5: while (entryIterator.hasNext()) {
            Map.Entry<String, AnimationTicker> entry = entryIterator.next();
            AnimationTicker ticker = entry.getValue();
            Animation animation = ticker.getAnimation();
            if (ticker.hasEnded()) {
                Animation.LoopMode mode = ticker.getLoopMode();
                if (animation.isToNullTransition()) {
                    entryIterator.remove();
                    continue;
                }
                AnimationContext context = new AnimationContext(animation);
                context.variables = this.variables;
                ticker.addVariables(context, 0.0f);
                switch (mode) {
                    case ONCE: {
                        int toNullTime = ticker.getToNullTransitionTime();
                        if (toNullTime != 0) {
                            Animation nullTransition = animation.createTransitionTo(context, null, ticker.getTime(0.0f), ticker.getToNullTransitionTime(), false);
                            ticker.resetTime();
                            ticker.setAnimation(nullTransition);
                            break;
                        }
                        entryIterator.remove();
                        continue block5;
                    }
                    case LOOP: {
                        ticker.resetTime();
                        if (!animation.isTransition()) break;
                        ticker.setAnimation(((TransitionAnimation)animation).getTransitionTo());
                        break;
                    }
                    case HOLD_ON_LAST_FRAME: {
                        continue block5;
                    }
                }
            }
            ticker.tick();
        }
    }

    public void applyAnimations(FDModel model, float partialTicks) {
        model.resetTransformations();
        for (AnimationTicker entry : this.tickers.values()) {
            Animation animation = entry.getAnimation();
            AnimationContext context = new AnimationContext(animation);
            context.variables = this.variables;
            entry.addVariables(context, partialTicks);
            animation.applyAnimation(context, model, entry.getTime(partialTicks));
        }
    }

    public void setFrozen(boolean frozen) {
        this.isFrozen = frozen;
        this.onFreeze(frozen);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void startAnimation(String name, AnimationTicker ticker) {
        AnimationTicker current = this.getTicker(name);
        if (current == null) {
            this.tickers.put(name, ticker);
        } else {
            if (ticker.equals(current)) {
                return;
            }
            Animation anim = current.getAnimation();
            AnimationContext context = new AnimationContext(anim);
            context.variables = this.variables;
            current.addVariables(context, 0.0f);
            Animation transition = current.getAnimation().createTransitionTo(context, ticker.getAnimation(), current.getTime(0.0f), ticker.getToNullTransitionTime(), ticker.isReversed());
            AnimationTicker newTicker = new AnimationTicker(ticker);
            newTicker.setAnimation(transition);
            newTicker.resetTime();
            this.tickers.put(name, newTicker);
        }
        this.onAnimationStart(name, ticker);
    }

    public void stopAnimation(String name) {
        Animation animation;
        AnimationTicker ticker = this.getTicker(name);
        if (ticker != null && !(animation = ticker.getAnimation()).isToNullTransition()) {
            if (ticker.getToNullTransitionTime() != 0) {
                AnimationContext context = new AnimationContext(animation);
                context.variables = this.variables;
                ticker.addVariables(context, 0.0f);
                Animation toNull = animation.createTransitionTo(context, null, ticker.getTime(0.0f), ticker.getToNullTransitionTime(), false);
                AnimationTicker newTicker = new AnimationTicker(ticker);
                newTicker.setLoopMode(Animation.LoopMode.ONCE);
                newTicker.setAnimation(toNull);
                this.tickers.put(name, newTicker);
            } else {
                this.tickers.remove(name);
            }
        }
        this.onAnimationStop(name);
    }

    public void setVariable(String name, float variable) {
        this.variables.put(name, Float.valueOf(variable));
        this.onVariableAdded(name, variable);
    }

    public float getVariable(String name) {
        return this.variables.get(name).floatValue();
    }

    public AnimationTicker getTicker(String name) {
        return this.tickers.get(name);
    }

    public Animation getTickerAnimation(String ticker) {
        if (this.tickers.containsKey(ticker)) {
            return this.getTicker(ticker).getAnimation();
        }
        return null;
    }

    public HashMap<String, AnimationTicker> getTickers() {
        return this.tickers;
    }

    public abstract void onAnimationStart(String var1, AnimationTicker var2);

    public abstract void onAnimationStop(String var1);

    public abstract void onFreeze(boolean var1);

    public abstract void onVariableAdded(String var1, float var2);
}

