/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.EntityAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.packets.SyncEntityAnimationsPacket;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class FDLivingEntity
extends LivingEntity
implements AnimatedObject {
    private static final List<ItemStack> DUMMY_LIST = List.of();
    public AnimationSystem animationSystem = EntityAnimationSystem.create(this);

    protected FDLivingEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        this.tickAnimationSystem();
    }

    @Override
    public AnimationSystem getSystem() {
        return this.animationSystem;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        SyncEntityAnimationsPacket packet = new SyncEntityAnimationsPacket(this.getId(), this.getSystem().getTickers());
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return DUMMY_LIST;
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21127_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }
}

