/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDEntityRenderLayer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDEntityRenderLayerOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDFreeEntityRenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.IShouldEntityRender;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.FDColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FDEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    public List<FDEntityRenderLayer<T>> layers;
    public IShouldEntityRender<T> shouldRender;
    public FDFreeEntityRenderer<T> freeRender;

    public FDEntityRenderer(EntityRendererProvider.Context ctx, IShouldEntityRender<T> shouldRender, List<FDEntityRenderLayerOptions<T>> layerDefinitions, FDFreeEntityRenderer<T> freeEntityRenderer) {
        super(ctx);
        this.freeRender = freeEntityRenderer;
        this.shouldRender = shouldRender;
        this.layers = new ArrayList<FDEntityRenderLayer<T>>();
        for (FDEntityRenderLayerOptions<T> layer : layerDefinitions) {
            FDModel model = new FDModel(layer.layerModel.get());
            FDEntityRenderLayer l = new FDEntityRenderLayer(model, layer.renderType, layer.renderCondition, layer.transform, layer.layerColor, layer.ignoreHurtOverlay);
            this.layers.add(l);
        }
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack matrices, MultiBufferSource src, int light) {
        super.render(entity, yaw, partialTicks, matrices, src, light);
        this.applyAnimations(entity, yaw, partialTicks, matrices, src, light);
        this.renderLayers(entity, yaw, partialTicks, matrices, src, light);
        if (this.freeRender != null) {
            this.freeRender.render(entity, yaw, partialTicks, matrices, src, light);
        }
    }

    public void applyAnimations(T entity, float yaw, float partialTicks, PoseStack matrices, MultiBufferSource src, int light) {
        AnimationSystem system = ((AnimatedObject)entity).getSystem();
        for (FDEntityRenderLayer<T> layer : this.layers) {
            FDModel model = layer.model();
            system.applyAnimations(model, partialTicks);
            model.main.addYRot(-yaw);
        }
    }

    public void renderLayers(T entity, float idk, float partialTicks, PoseStack matrices, MultiBufferSource src, int light) {
        for (FDEntityRenderLayer<T> layer : this.layers) {
            Function<T, Boolean> condition = layer.renderCondition();
            if (!condition.apply(entity).booleanValue()) continue;
            matrices.pushPose();
            FDModel model = layer.model();
            RenderType type = layer.renderType().getValue(entity, partialTicks);
            VertexConsumer consumer = src.getBuffer(type);
            int overlay = OverlayTexture.NO_OVERLAY;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!layer.ignoreHurtOverlay()) {
                    overlay = LivingEntityRenderer.getOverlayCoords((LivingEntity)livingEntity, (float)0.0f);
                }
            }
            layer.matrixTransform().apply(entity, matrices, partialTicks);
            FDColor color = layer.color().getValue(entity, partialTicks);
            model.render(matrices, consumer, light, overlay, color.r, color.g, color.b, color.a);
            matrices.popPose();
        }
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        if (this.shouldRender != null) {
            return this.shouldRender.shouldRender(entity, frustum, x, y, z);
        }
        return super.shouldRender(entity, frustum, x, y, z);
    }
}

