/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRendererOptions;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class FDModelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public List<FDModel> models;
    public FDModelItemRendererOptions options;

    public FDModelItemRenderer(FDModelItemRendererOptions options) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.options = options;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.initModelsIfNecessary();
        float scale = this.options.scale.apply(displayContext).floatValue();
        if (displayContext == ItemDisplayContext.GUI) {
            translation = this.options.translation.apply(displayContext);
            matrices.translate(0.5 + (double)translation.x, (double)(0.25f + translation.y), 0.5 + (double)translation.z);
            matrices.mulPose(Axis.XP.rotationDegrees(35.0f));
            matrices.mulPose(Axis.YP.rotationDegrees(45.0f + this.options.rotation.apply(displayContext).floatValue()));
        } else {
            translation = this.options.translation.apply(displayContext);
            if (displayContext == ItemDisplayContext.GROUND) {
                matrices.translate(0.5 + (double)translation.x, 0.3 + (double)translation.y, 0.5 + (double)translation.z);
            } else {
                matrices.translate(0.5 + (double)translation.z, 0.5 + (double)translation.y, 0.5 + (double)translation.x);
            }
            matrices.mulPose(Axis.YP.rotationDegrees(this.options.rotation.apply(displayContext).floatValue()));
        }
        matrices.scale(scale, scale, scale);
        for (int i = 0; i < this.models.size(); ++i) {
            FDModel model = this.models.get(i);
            VertexConsumer vertex = buffer.getBuffer(this.options.renderTypes.get(i));
            model.render(matrices, vertex, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void initModelsIfNecessary() {
        if (this.models == null) {
            this.models = new ArrayList<FDModel>();
            for (Supplier<FDModelInfo> sup : this.options.modelInfos) {
                this.models.add(new FDModel(sup.get()));
            }
        }
    }

    public static IClientItemExtensions createExtensions(final FDModelItemRendererOptions options) {
        return new IClientItemExtensions(){
            private FDModelItemRenderer renderer;
            {
                this.renderer = new FDModelItemRenderer(options);
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        };
    }
}

